/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitManager;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.trait.Sheared;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WoolColor;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.plugin.Plugin;

public class CitizensTraitManager
implements TraitManager {
    private final Map<Class<? extends Trait>, Constructor<? extends Trait>> CACHED_CTORS = new HashMap<Class<? extends Trait>, Constructor<? extends Trait>>();
    private final Map<Plugin, Map<String, Class<? extends Trait>>> registered = new HashMap<Plugin, Map<String, Class<? extends Trait>>>();

    public CitizensTraitManager(Citizens plugin) {
        this.registerTrait(new TraitFactory(Age.class).withName("age").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(CurrentLocation.class).withName("location").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Equipment.class).withName("equipment").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Inventory.class).withName("inventory").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(LookClose.class).withName("look-close").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(MobType.class).withName("type").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Owner.class).withName("owner").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Powered.class).withName("powered").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Saddle.class).withName("saddle").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Sheared.class).withName("sheared").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Spawned.class).withName("spawned").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Text.class).withName("text").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(VillagerProfession.class).withName("profession").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Waypoints.class).withName("waypoints").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(WoolColor.class).withName("wool-color").withPlugin((Plugin)plugin));
        this.registerTrait(new TraitFactory(Controllable.class).withName("controllable").withPlugin((Plugin)plugin));
    }

    private <T extends Trait> T create(Class<T> trait, NPC npc) {
        Constructor<Trait> constructor;
        if (!this.CACHED_CTORS.containsKey(trait)) {
            try {
                constructor = trait.getConstructor(NPC.class);
                if (constructor == null) {
                    constructor = trait.getConstructor(CitizensNPC.class);
                }
                constructor.setAccessible(true);
            }
            catch (Exception ex) {
                constructor = null;
            }
            this.CACHED_CTORS.put(trait, constructor);
        } else {
            constructor = this.CACHED_CTORS.get(trait);
        }
        try {
            if (constructor == null || npc == null) {
                return (T)((Trait)trait.newInstance());
            }
            return (T)constructor.newInstance(npc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getTrait(clazz, null);
    }

    public <T extends Trait> T getTrait(Class<T> clazz, NPC npc) {
        for (Map.Entry<Plugin, Map<String, Class<? extends Trait>>> entry : this.registered.entrySet()) {
            for (Map.Entry<String, Class<? extends Trait>> subEntry : entry.getValue().entrySet()) {
                if (!subEntry.getValue().equals(clazz)) continue;
                Trait trait = this.create(subEntry.getValue(), npc);
                if (trait == null) {
                    return null;
                }
                trait.setName(subEntry.getKey());
                trait.setPlugin(entry.getKey());
                return (T)trait;
            }
        }
        return null;
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        Iterator<Plugin> i$ = this.registered.keySet().iterator();
        if (i$.hasNext()) {
            Plugin plugin = i$.next();
            if (!this.registered.get(plugin).containsKey(name)) {
                return null;
            }
            return (T)this.create(this.registered.get(plugin).get(name), null);
        }
        return null;
    }

    public <T extends Trait> T getTrait(String name, NPC npc) {
        for (Plugin plugin : this.registered.keySet()) {
            Class<? extends Trait> clazz = this.registered.get(plugin).get(name);
            if (clazz == null) continue;
            return (T)this.getTrait(clazz, npc);
        }
        return null;
    }

    @Override
    public void registerTrait(TraitFactory factory) {
        Map<String, Class<? extends Trait>> map = this.registered.get(factory.getTraitPlugin());
        if (map == null) {
            map = new HashMap<String, Class<? extends Trait>>();
        }
        map.put(factory.getTraitName(), factory.getTraitClass());
        this.registered.put(factory.getTraitPlugin(), map);
    }
}

