/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.CitizensAI;
import org.apache.commons.lang.Validate;

public class Behaviour
extends Trait {
    private final List<File> scripts = Lists.newArrayList();
    private final List<CitizensAI.GoalEntry> addedGoals = Lists.newArrayList();
    private final File rootFolder = new File(CitizensAPI.getScriptFolder(), "behaviours");
    private final NPC npc;

    public Behaviour(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.reset();
        if (!key.keyExists("scripts")) {
            return;
        }
        String scripts = key.getString("scripts");
        this.addScripts(Splitter.on((String)",").split((CharSequence)scripts));
    }

    private void reset() {
        this.removeGoals();
        this.scripts.clear();
        this.addedGoals.clear();
    }

    private void removeGoals() {
        for (CitizensAI.GoalEntry entry : this.addedGoals) {
            this.npc.getAI().removeGoal(entry.getGoal());
        }
    }

    @Override
    public void onNPCSpawn() {
        for (CitizensAI.GoalEntry entry : this.addedGoals) {
            this.npc.getAI().addGoal(entry.getPriority(), entry.getGoal());
        }
    }

    @Override
    public void onRemove() {
        this.removeGoals();
    }

    public void addScripts(Iterable<String> scripts) {
        BehaviourCallback callback = new BehaviourCallback(new Goals());
        for (String script : scripts) {
            File file = new File(this.rootFolder, script);
            if (!file.exists()) continue;
            CitizensAPI.getScriptCompiler().compile(file).withCallback(callback).begin();
            this.scripts.add(file);
        }
        List added = callback.goals.goals;
        for (CitizensAI.GoalEntry entry : added) {
            this.npc.getAI().addGoal(entry.getPriority(), entry.getGoal());
        }
        this.addedGoals.addAll(added);
    }

    @Override
    public void save(DataKey key) {
        key.setString("scripts", Joiner.on((String)",").join(this.scripts));
    }

    public static class Goals {
        private final List<CitizensAI.GoalEntry> goals = Lists.newArrayList();

        public void addGoal(int priority, Goal goal) {
            Validate.notNull((Object)goal);
            this.goals.add(new CitizensAI.GoalEntry(priority, goal));
        }
    }

    private class BehaviourCallback
    implements CompileCallback {
        private final Goals goals;

        private BehaviourCallback(Goals goals) {
            this.goals = goals;
        }

        @Override
        public void onScriptCompiled(ScriptFactory script) {
            script.newInstance().invoke("addGoals", this.goals, Behaviour.this.npc);
        }
    }
}

