/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCLookCloseChangeTargetEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;

@TraitName(value="lookclose")
public class LookClose
extends Trait {
    @Persist(value="disablewhilenavigating")
    private boolean disableWhileNavigating = Settings.Setting.DISABLE_LOOKCLOSE_WHILE_NAVIGATING.asBoolean();
    @Persist(value="enabled")
    private boolean enabled = Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean();
    @Persist
    private boolean enableRandomLook = Settings.Setting.DEFAULT_RANDOM_LOOK_CLOSE.asBoolean();
    @Persist(value="headonly")
    private boolean headOnly;
    @Persist(value="linkedbody")
    private boolean linkedBody;
    private Player lookingAt;
    @Persist(value="perplayer")
    private boolean perPlayer;
    @Persist
    private int randomLookDelay = Settings.Setting.DEFAULT_RANDOM_LOOK_DELAY.asTicks();
    @Persist
    private float[] randomPitchRange = new float[]{0.0f, 0.0f};
    @Persist
    private boolean randomSwitchTargets;
    @Persist
    private float[] randomYawRange = new float[]{0.0f, 360.0f};
    private double range = Settings.Setting.DEFAULT_LOOK_CLOSE_RANGE.asDouble();
    @Persist(value="realisticlooking")
    private boolean realisticLooking = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private final Map<UUID, RotationTrait.PacketRotationSession> sessions = Maps.newHashMapWithExpectedSize((int)4);
    private int t;
    @Persist(value="targetnpcs")
    private boolean targetNPCs;

    public LookClose() {
        super("lookclose");
    }

    private boolean canSee(Player player) {
        if (player == null || !player.isValid()) {
            return false;
        }
        return this.realisticLooking && this.npc.getEntity() instanceof LivingEntity ? ((LivingEntity)this.npc.getEntity()).hasLineOfSight((Entity)player) : true;
    }

    public boolean canSeeTarget() {
        return this.canSee(this.lookingAt);
    }

    public boolean disableWhileNavigating() {
        return this.disableWhileNavigating;
    }

    public void findNewTarget() {
        if (this.perPlayer) {
            this.lookingAt = null;
            RotationTrait rotationTrait = this.npc.getOrAddTrait(RotationTrait.class);
            HashSet seen = Sets.newHashSet();
            for (Player player : this.getNearbyPlayers()) {
                RotationTrait.PacketRotationSession session = this.sessions.get(player.getUniqueId());
                if (session == null) {
                    session = rotationTrait.createPacketSession(rotationTrait.getGlobalParameters().clone().linkedBody(this.linkedBody).headOnly(this.headOnly).uuidFilter(player.getUniqueId()).persist(true));
                    this.sessions.put(player.getUniqueId(), session);
                }
                session.getSession().rotateToFace((Entity)player);
                seen.add(player.getUniqueId());
            }
            Iterator<UUID> iterator = this.sessions.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                if (seen.contains(uuid)) continue;
                rotationTrait.resetPlayerToPhysicalSession(uuid);
                iterator.remove();
            }
            return;
        }
        if (this.sessions.size() > 0) {
            RotationTrait rotationTrait = this.npc.getOrAddTrait(RotationTrait.class);
            for (UUID uuid : this.sessions.keySet()) {
                rotationTrait.resetPlayerToPhysicalSession(uuid);
            }
            this.sessions.clear();
        }
        if (this.lookingAt != null && !this.isValid(this.lookingAt)) {
            NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.lookingAt = event.getNewTarget() != null && this.isValid(event.getNewTarget()) ? event.getNewTarget() : null;
        }
        Player old = this.lookingAt;
        if (this.lookingAt != null) {
            List<Player> options;
            if (this.randomSwitchTargets && this.t <= 0 && (options = this.getNearbyPlayers()).size() > 0) {
                this.lookingAt = options.get(Util.getFastRandom().nextInt(options.size()));
                this.t = this.randomLookDelay;
            }
        } else {
            double min = Double.MAX_VALUE;
            Location npcLoc = this.npc.getEntity().getLocation();
            for (Player player : this.getNearbyPlayers()) {
                double dist = player.getLocation().distance(npcLoc);
                if (dist > min) continue;
                min = dist;
                this.lookingAt = player;
            }
        }
        if (old != this.lookingAt) {
            NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, old, this.lookingAt);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (this.lookingAt != event.getNewTarget() && event.getNewTarget() != null && !this.isValid(event.getNewTarget())) {
                return;
            }
            this.lookingAt = event.getNewTarget();
        }
    }

    private List<Player> getNearbyPlayers() {
        ArrayList options = Lists.newArrayList();
        Location npcLoc = this.npc.getStoredLocation();
        Iterable nearby = this.targetNPCs ? (Iterable)this.npc.getEntity().getNearbyEntities(this.range, this.range, this.range).stream().filter(e -> e.getType() == EntityType.PLAYER && e.getWorld() == npcLoc.getWorld()).map(e -> (Player)e).collect(Collectors.toList()) : CitizensAPI.getLocationLookup().getNearbyPlayers(npcLoc, this.range);
        for (Player player : nearby) {
            if (player == this.lookingAt || player.getWorld() != this.npc.getEntity().getWorld() || !this.targetNPCs && CitizensAPI.getNPCRegistry().getNPC((Entity)player) != null || this.isInvisible(player)) continue;
            options.add(player);
        }
        return options;
    }

    public int getRandomLookDelay() {
        return this.randomLookDelay;
    }

    public float[] getRandomLookPitchRange() {
        return this.randomPitchRange;
    }

    public float[] getRandomLookYawRange() {
        return this.randomYawRange;
    }

    public double getRange() {
        return this.range;
    }

    public Player getTarget() {
        return this.lookingAt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHeadOnly() {
        return this.headOnly;
    }

    private boolean isInvisible(Player player) {
        return player.getGameMode() == GameMode.SPECTATOR || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || this.isPluginVanished(player) || !this.canSee(player);
    }

    private boolean isPluginVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public boolean isRandomLook() {
        return this.enableRandomLook;
    }

    private boolean isValid(Player entity) {
        return entity.isOnline() && entity.isValid() && entity.getWorld() == this.npc.getEntity().getWorld() && entity.getLocation().distance(this.npc.getStoredLocation()) <= this.range && !this.isInvisible(entity);
    }

    @Override
    public void load(DataKey key) {
        this.range = key.getDouble("range");
    }

    public void lookClose(boolean lookClose) {
        this.enabled = lookClose;
    }

    @Override
    public void onDespawn() {
        NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.lookingAt = event.getNewTarget() != null && this.isValid(event.getNewTarget()) ? event.getNewTarget() : null;
    }

    private void randomLook() {
        float pitch = LookClose.isEqual(this.randomPitchRange) ? this.randomPitchRange[0] : Util.getFastRandom().doubles(this.randomPitchRange[0], this.randomPitchRange[1]).iterator().next().floatValue();
        float yaw = LookClose.isEqual(this.randomYawRange) ? this.randomYawRange[0] : Util.getFastRandom().doubles(this.randomYawRange[0], this.randomYawRange[1]).iterator().next().floatValue();
        this.npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(yaw, pitch);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            this.lookingAt = null;
            return;
        }
        if (this.enableRandomLook && !this.npc.getNavigator().isNavigating() && this.lookingAt == null && this.t <= 0) {
            this.randomLook();
            this.t = this.randomLookDelay;
        }
        --this.t;
        if (!this.enabled || this.npc.getNavigator().isNavigating() && this.disableWhileNavigating()) {
            this.lookingAt = null;
            return;
        }
        this.findNewTarget();
        if (this.npc.getNavigator().isNavigating() || this.npc.getNavigator().isPaused()) {
            this.npc.getNavigator().setPaused(this.lookingAt != null);
        }
        if (this.lookingAt == null) {
            return;
        }
        RotationTrait rot = this.npc.getOrAddTrait(RotationTrait.class);
        rot.getGlobalParameters().headOnly(this.headOnly);
        rot.getGlobalParameters().linkedBody(this.linkedBody);
        rot.getPhysicalSession().rotateToFace((Entity)this.lookingAt);
        if (this.npc.getEntity().getType().name().equals("SHULKER")) {
            boolean wasSilent = this.npc.getEntity().isSilent();
            this.npc.getEntity().setSilent(true);
            NMS.setPeekShulker(this.npc.getEntity(), 100 - 4 * (int)Math.floor(this.npc.getStoredLocation().distanceSquared(this.lookingAt.getLocation())));
            this.npc.getEntity().setSilent(wasSilent);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setDouble("range", this.range);
    }

    public void setDisableWhileNavigating(boolean set) {
        this.disableWhileNavigating = set;
    }

    public void setHeadOnly(boolean headOnly) {
        this.headOnly = headOnly;
    }

    public void setLinkedBody(boolean linkedBody) {
        this.linkedBody = linkedBody;
    }

    public void setPerPlayer(boolean perPlayer) {
        this.perPlayer = perPlayer;
    }

    public void setRandomLook(boolean enableRandomLook) {
        this.enableRandomLook = enableRandomLook;
    }

    public void setRandomLookDelay(int delay) {
        this.randomLookDelay = delay;
    }

    public void setRandomLookPitchRange(float min, float max) {
        this.randomPitchRange = new float[]{min, max};
    }

    public void setRandomLookYawRange(float min, float max) {
        this.randomYawRange = new float[]{min, max};
    }

    public void setRandomlySwitchTargets(boolean randomSwitchTargets) {
        this.randomSwitchTargets = randomSwitchTargets;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void setRealisticLooking(boolean realistic) {
        this.realisticLooking = realistic;
    }

    public void setTargetNPCs(boolean target) {
        this.targetNPCs = target;
    }

    public boolean targetNPCs() {
        return this.targetNPCs;
    }

    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }

    public String toString() {
        return "LookClose{" + this.enabled + "}";
    }

    public boolean useRealisticLooking() {
        return this.realisticLooking;
    }

    private static boolean isEqual(float[] array) {
        return (double)Math.abs(array[0] - array[1]) < 0.001;
    }
}

