/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftItemDisplay;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;

public class ItemDisplayController
extends MobEntityController {
    public ItemDisplayController() {
        super(EntityItemDisplayNPC.class, EntityTypes.as);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        EntityItemDisplayNPC handle = new EntityItemDisplayNPC((EntityTypes<? extends Display.ItemDisplay>)EntityTypes.as, (World)((CraftWorld)at.getWorld()).getHandle(), npc);
        if (npc != null) {
            handle.a(CraftItemStack.asNMSCopy((ItemStack)npc.getItemProvider().get()));
        }
        return handle.getBukkitEntity();
    }

    public ItemDisplay getBukkitEntity() {
        return (ItemDisplay)super.getBukkitEntity();
    }

    public static class EntityItemDisplayNPC
    extends Display.ItemDisplay
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemDisplayNPC(EntityTypes<? extends Display.ItemDisplay> types, World level) {
            this(types, level, null);
        }

        public EntityItemDisplayNPC(EntityTypes<? extends Display.ItemDisplay> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ItemDisplayNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction i_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.i_();
        }

        public boolean bG() {
            return this.npc == null ? super.bG() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean g(NBTTagCompound save) {
            return this.npc == null ? super.g(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            super.g();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class ItemDisplayNPC
    extends CraftItemDisplay
    implements ForwardingNPCHolder {
        public ItemDisplayNPC(EntityItemDisplayNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Display.ItemDisplay)entity);
        }
    }
}

