/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.datafixers.util.Pair;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.invoke.MethodHandle;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCMoveEvent;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_19_R3.entity.AllayController;
import net.citizensnpcs.nms.v1_19_R3.entity.ArmorStandController;
import net.citizensnpcs.nms.v1_19_R3.entity.AxolotlController;
import net.citizensnpcs.nms.v1_19_R3.entity.BatController;
import net.citizensnpcs.nms.v1_19_R3.entity.BeeController;
import net.citizensnpcs.nms.v1_19_R3.entity.BlazeController;
import net.citizensnpcs.nms.v1_19_R3.entity.CamelController;
import net.citizensnpcs.nms.v1_19_R3.entity.CatController;
import net.citizensnpcs.nms.v1_19_R3.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_19_R3.entity.ChickenController;
import net.citizensnpcs.nms.v1_19_R3.entity.CodController;
import net.citizensnpcs.nms.v1_19_R3.entity.CowController;
import net.citizensnpcs.nms.v1_19_R3.entity.CreeperController;
import net.citizensnpcs.nms.v1_19_R3.entity.DolphinController;
import net.citizensnpcs.nms.v1_19_R3.entity.DrownedController;
import net.citizensnpcs.nms.v1_19_R3.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_19_R3.entity.EndermanController;
import net.citizensnpcs.nms.v1_19_R3.entity.EndermiteController;
import net.citizensnpcs.nms.v1_19_R3.entity.EvokerController;
import net.citizensnpcs.nms.v1_19_R3.entity.FoxController;
import net.citizensnpcs.nms.v1_19_R3.entity.FrogController;
import net.citizensnpcs.nms.v1_19_R3.entity.GhastController;
import net.citizensnpcs.nms.v1_19_R3.entity.GiantController;
import net.citizensnpcs.nms.v1_19_R3.entity.GlowSquidController;
import net.citizensnpcs.nms.v1_19_R3.entity.GoatController;
import net.citizensnpcs.nms.v1_19_R3.entity.GuardianController;
import net.citizensnpcs.nms.v1_19_R3.entity.GuardianElderController;
import net.citizensnpcs.nms.v1_19_R3.entity.HoglinController;
import net.citizensnpcs.nms.v1_19_R3.entity.HorseController;
import net.citizensnpcs.nms.v1_19_R3.entity.HorseDonkeyController;
import net.citizensnpcs.nms.v1_19_R3.entity.HorseMuleController;
import net.citizensnpcs.nms.v1_19_R3.entity.HorseSkeletonController;
import net.citizensnpcs.nms.v1_19_R3.entity.HorseZombieController;
import net.citizensnpcs.nms.v1_19_R3.entity.HumanController;
import net.citizensnpcs.nms.v1_19_R3.entity.IllusionerController;
import net.citizensnpcs.nms.v1_19_R3.entity.IronGolemController;
import net.citizensnpcs.nms.v1_19_R3.entity.LlamaController;
import net.citizensnpcs.nms.v1_19_R3.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_19_R3.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_19_R3.entity.OcelotController;
import net.citizensnpcs.nms.v1_19_R3.entity.PandaController;
import net.citizensnpcs.nms.v1_19_R3.entity.ParrotController;
import net.citizensnpcs.nms.v1_19_R3.entity.PhantomController;
import net.citizensnpcs.nms.v1_19_R3.entity.PigController;
import net.citizensnpcs.nms.v1_19_R3.entity.PigZombieController;
import net.citizensnpcs.nms.v1_19_R3.entity.PiglinBruteController;
import net.citizensnpcs.nms.v1_19_R3.entity.PiglinController;
import net.citizensnpcs.nms.v1_19_R3.entity.PillagerController;
import net.citizensnpcs.nms.v1_19_R3.entity.PolarBearController;
import net.citizensnpcs.nms.v1_19_R3.entity.PufferFishController;
import net.citizensnpcs.nms.v1_19_R3.entity.RabbitController;
import net.citizensnpcs.nms.v1_19_R3.entity.RavagerController;
import net.citizensnpcs.nms.v1_19_R3.entity.SalmonController;
import net.citizensnpcs.nms.v1_19_R3.entity.SheepController;
import net.citizensnpcs.nms.v1_19_R3.entity.ShulkerController;
import net.citizensnpcs.nms.v1_19_R3.entity.SilverfishController;
import net.citizensnpcs.nms.v1_19_R3.entity.SkeletonController;
import net.citizensnpcs.nms.v1_19_R3.entity.SkeletonStrayController;
import net.citizensnpcs.nms.v1_19_R3.entity.SkeletonWitherController;
import net.citizensnpcs.nms.v1_19_R3.entity.SlimeController;
import net.citizensnpcs.nms.v1_19_R3.entity.SnifferController;
import net.citizensnpcs.nms.v1_19_R3.entity.SnowmanController;
import net.citizensnpcs.nms.v1_19_R3.entity.SpiderController;
import net.citizensnpcs.nms.v1_19_R3.entity.SquidController;
import net.citizensnpcs.nms.v1_19_R3.entity.StriderController;
import net.citizensnpcs.nms.v1_19_R3.entity.TadpoleController;
import net.citizensnpcs.nms.v1_19_R3.entity.TraderLlamaController;
import net.citizensnpcs.nms.v1_19_R3.entity.TropicalFishController;
import net.citizensnpcs.nms.v1_19_R3.entity.TurtleController;
import net.citizensnpcs.nms.v1_19_R3.entity.VexController;
import net.citizensnpcs.nms.v1_19_R3.entity.VillagerController;
import net.citizensnpcs.nms.v1_19_R3.entity.VindicatorController;
import net.citizensnpcs.nms.v1_19_R3.entity.WanderingTraderController;
import net.citizensnpcs.nms.v1_19_R3.entity.WardenController;
import net.citizensnpcs.nms.v1_19_R3.entity.WitchController;
import net.citizensnpcs.nms.v1_19_R3.entity.WitherController;
import net.citizensnpcs.nms.v1_19_R3.entity.WolfController;
import net.citizensnpcs.nms.v1_19_R3.entity.ZoglinController;
import net.citizensnpcs.nms.v1_19_R3.entity.ZombieController;
import net.citizensnpcs.nms.v1_19_R3.entity.ZombieHuskController;
import net.citizensnpcs.nms.v1_19_R3.entity.ZombieVillagerController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.AreaEffectCloudController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.BlockDisplayController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ChestBoatController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.DragonFireballController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.EnderSignalController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.EvokerFangsController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ExperienceOrbController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.GlowItemFrameController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.InteractionController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ItemDisplayController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.LlamaSpitController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MarkerController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartSpawnerController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ShulkerBulletController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.SpectralArrowController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.TextDisplayController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ThrownPotionController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.ThrownTridentController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.TippedArrowController;
import net.citizensnpcs.nms.v1_19_R3.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_19_R3.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_19_R3.util.CitizensEntityTracker;
import net.citizensnpcs.nms.v1_19_R3.util.CustomEntityRegistry;
import net.citizensnpcs.nms.v1_19_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_19_R3.util.MobAI;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.PlayerAnimationImpl;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.versioned.AllayTrait;
import net.citizensnpcs.trait.versioned.AreaEffectCloudTrait;
import net.citizensnpcs.trait.versioned.AxolotlTrait;
import net.citizensnpcs.trait.versioned.BeeTrait;
import net.citizensnpcs.trait.versioned.BoatTrait;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CamelTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.DisplayTrait;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.FrogTrait;
import net.citizensnpcs.trait.versioned.GoatTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PiglinTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnifferTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.SpellcasterTrait;
import net.citizensnpcs.trait.versioned.TextDisplayTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VexTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.trait.versioned.WardenTrait;
import net.citizensnpcs.util.EmptyChannel;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_19_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryView;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getFirstGetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFirstFinalSetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_SUPPLIER = NMS.getFirstGetter(AttributeMapBase.class, AttributeProvider.class);
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.POLAR_BEAR, new EntityType[]{EntityType.BEE, EntityType.SILVERFISH, EntityType.SHULKER, EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.DOLPHIN, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST, EntityType.SHULKER, EntityType.PHANTOM});
    private static final MethodHandle BEHAVIOR_TREE_MAP = NMS.getGetter(BehaviorController.class, "f");
    private static final MethodHandle BUKKITENTITY_FIELD_SETTER = NMS.getSetter(net.minecraft.world.entity.Entity.class, "bukkitEntity");
    private static final MethodHandle CHUNKMAP_UPDATE_PLAYER_STATUS = NMS.getMethodHandle(PlayerChunkMap.class, "a", true, EntityPlayer.class, Boolean.TYPE);
    private static final Map<Class<?>, EntityTypes<?>> CITIZENS_ENTITY_TYPES = Maps.newHashMap();
    private static final MethodHandle CRAFT_BOSSBAR_HANDLE_FIELD = NMS.getFirstSetter(CraftBossBar.class, BossBattleServer.class);
    private static final DataWatcherObject<Boolean> DATA_NAME_VISIBLE = (DataWatcherObject)NMS.getStaticObject(net.minecraft.world.entity.Entity.class, "aS");
    private static final DataWatcherObject<EntityPose> DATA_POSE = (DataWatcherObject)NMS.getStaticObject(net.minecraft.world.entity.Entity.class, "ar");
    private static final float DEFAULT_SPEED = 1.0f;
    public static final MethodHandle ENDERDRAGON_CHECK_WALLS = NMS.getFirstMethodHandleWithReturnType(EntityEnderDragon.class, true, Boolean.TYPE, AxisAlignedBB.class);
    private static final DataWatcherObject<Boolean> ENDERMAN_CREEPY = (DataWatcherObject)NMS.getStaticObject(EntityEnderman.class, "bU");
    private static final MethodHandle ENTITY_FISH_NUM_IN_SCHOOL = NMS.getFirstSetter(EntityFishSchool.class, Integer.TYPE);
    private static final MethodHandle ENTITY_NAVIGATION = NMS.getFirstSetter(EntityInsentient.class, NavigationAbstract.class);
    private static CustomEntityRegistry ENTITY_REGISTRY;
    private static MethodHandle ENTITY_REGISTRY_SETTER;
    private static final MethodHandle FALLING_BLOCK_STATE_SETTER;
    private static final MethodHandle FIND_DIMENSION_ENTRY_POINT;
    private static final MethodHandle FISHING_HOOK_LIFE;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_GETTER;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_SETTER;
    private static final Location FROM_LOCATION;
    private static final MethodHandle HEAD_HEIGHT;
    private static final MethodHandle HEAD_HEIGHT_METHOD;
    private static final DataWatcherObject<Float> INTERACTION_HEIGHT;
    private static final DataWatcherObject<Float> INTERACTION_WIDTH;
    private static final MethodHandle JUMP_FIELD;
    private static final MethodHandle LOOK_CONTROL_SETTER;
    private static final MethodHandle MAKE_REQUEST;
    private static MethodHandle MOVE_CONTROLLER_OPERATION;
    private static final MethodHandle NAVIGATION_CREATE_PATHFINDER;
    private static MethodHandle NAVIGATION_PATH;
    private static final MethodHandle NAVIGATION_PATHFINDER;
    private static final MethodHandle NAVIGATION_WORLD_FIELD;
    public static final MethodHandle PAPER_PLAYER_MOB_COUNTS;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER;
    private static final MethodHandle PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER;
    private static final MethodHandle PLAYER_INFO_ENTRIES_LIST;
    private static final MethodHandle PLAYERINFO_ENTRIES;
    private static final MethodHandle PORTAL_ENTRANCE_POS_GETTER;
    private static final MethodHandle PORTAL_ENTRANCE_POS_SETTER;
    private static final MethodHandle POSITION_CODEC_GETTER;
    private static final MethodHandle PUFFERFISH_C;
    private static final MethodHandle PUFFERFISH_D;
    private static final DataWatcherObject<Integer> RABBIT_TYPE_DATAWATCHER;
    private static final Random RANDOM;
    private static final MethodHandle SERVER_ENTITY_GETTER;
    private static MethodHandle SET_PROFILE_METHOD;
    private static final MethodHandle SIZE_FIELD_GETTER;
    private static final MethodHandle SIZE_FIELD_SETTER;
    private static MethodHandle SKULL_META_PROFILE;
    private static MethodHandle TEAM_FIELD;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public void activate(Entity entity) {
        NMSImpl.getHandle((Entity)entity).activatedTick = MinecraftServer.currentTick;
    }

    @Override
    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        int viewDistance = -1;
        PlayerChunkMap chunkMap = null;
        try {
            if (entity instanceof Player) {
                chunkMap = ((ChunkProviderServer)NMSImpl.getHandle((Entity)entity).H.I()).a;
                viewDistance = PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER.invoke(chunkMap);
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(chunkMap, -1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        boolean success = NMSImpl.getHandle((Entity)entity).H.addFreshEntity(NMSImpl.getHandle(entity), custom);
        try {
            if (chunkMap != null) {
                PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER.invoke(chunkMap, viewDistance);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return success;
    }

    @Override
    public void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle(entity);
        if (handle.H == null) {
            return;
        }
        List players = handle.H.v();
        boolean changed = false;
        if (remove && players.contains(handle)) {
            players.remove(handle);
            changed = true;
        } else if (!remove && !players.contains(handle)) {
            players.add(handle);
            changed = true;
        }
        if (!changed) {
            return;
        }
        try {
            CHUNKMAP_UPDATE_PLAYER_STATUS.invoke(((WorldServer)handle.H).k().a, handle, !remove);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void attack(LivingEntity attacker, LivingEntity btarget) {
        int fireAspectLevel;
        EntityLiving source = NMSImpl.getHandle(attacker);
        EntityLiving target = NMSImpl.getHandle(btarget);
        if (source instanceof EntityHuman) {
            ((EntityHuman)source).d((net.minecraft.world.entity.Entity)target);
            PlayerAnimation.ARM_SWING.play((Player)source.getBukkitEntity());
            return;
        }
        boolean hasAttackDamage = source.eI().b(GenericAttributes.f);
        if (source instanceof EntityInsentient && hasAttackDamage) {
            ((EntityInsentient)source).z((net.minecraft.world.entity.Entity)target);
            return;
        }
        float f = (float)(hasAttackDamage ? source.b(GenericAttributes.f) : 1.0);
        int i = 0;
        i += EnchantmentManager.c((EntityLiving)source);
        boolean flag = target.a(target.dG().b(source), f += EnchantmentManager.a((net.minecraft.world.item.ItemStack)source.eK(), (EnumMonsterType)target.eJ()));
        if (!flag) {
            return;
        }
        if (i > 0) {
            target.q(-Math.sin((double)source.dw() * Math.PI / 180.0) * (double)i * 0.5, 0.1, Math.cos((double)source.dw() * Math.PI / 180.0) * (double)i * 0.5);
            source.f(source.dj().d(0.6, 1.0, 0.6));
        }
        if ((fireAspectLevel = EnchantmentManager.d((EntityLiving)source)) > 0) {
            target.setSecondsOnFire(fireAspectLevel * 4, false);
        }
        if (target instanceof EntityPlayer) {
            net.minecraft.world.item.ItemStack itemstack1;
            EntityPlayer entityhuman = (EntityPlayer)target;
            net.minecraft.world.item.ItemStack itemstack = source.eK();
            net.minecraft.world.item.ItemStack itemStack = itemstack1 = entityhuman.fe() ? entityhuman.fg() : net.minecraft.world.item.ItemStack.b;
            if (!itemstack.b() && !itemstack1.b() && itemstack.c() instanceof ItemAxe && itemstack1.a(Items.ut)) {
                float f2 = 0.25f + (float)EnchantmentManager.g((EntityLiving)source) * 0.05f;
                Random random = new Random();
                if (random.nextFloat() < f2) {
                    entityhuman.ge().a(Items.ut, 100);
                    source.H.a((net.minecraft.world.entity.Entity)entityhuman, (byte)30);
                }
            }
        }
        EnchantmentManager.a((EntityLiving)source, (net.minecraft.world.entity.Entity)target);
        EnchantmentManager.b((EntityLiving)target, (net.minecraft.world.entity.Entity)source);
    }

    @Override
    public void cancelMoveDestination(Entity entity) {
        ControllerMove control;
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        MobAI ai = MobAI.from(handle);
        ControllerMove controllerMove = control = ai != null ? ai.getMoveControl() : null;
        if (control instanceof EntityMoveControl) {
            ((EntityMoveControl)control).moving = false;
        } else {
            try {
                MOVE_CONTROLLER_OPERATION.invoke(control, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean canNavigateTo(Entity entity, Location dest, NavigatorParameters params) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation.a(BlockPosition.a((double)dest.getX(), (double)dest.getY(), (double)dest.getZ()), 1) != null;
    }

    public Iterable<Object> createBundlePacket(List source) {
        return source.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)new ClientboundBundlePacket((Iterable)source));
    }

    @Override
    public EntityPacketTracker createPacketTracker(Entity entity, final EntityPacketTracker.PacketAggregator agg) {
        final net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        final Set linked = Sets.newIdentityHashSet();
        final EntityTrackerEntry tracker = new EntityTrackerEntry((WorldServer)handle.H, handle, handle.ae().p(), handle.ae().q(), agg::send, linked);
        final EnumMap equipment = Maps.newEnumMap(EnumItemSlot.class);
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                EntityPlayer p = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                handle.dD();
                tracker.b(p);
                linked.add(p.b);
                agg.add(p.cs(), packet -> p.b.a((Packet)packet));
            }

            @Override
            public void run() {
                if (handle instanceof EntityLiving) {
                    boolean changed = false;
                    EntityLiving entity = (EntityLiving)handle;
                    for (EnumItemSlot slot : EnumItemSlot.values()) {
                        net.minecraft.world.item.ItemStack old = equipment.getOrDefault(slot, net.minecraft.world.item.ItemStack.b);
                        net.minecraft.world.item.ItemStack curr = entity.c(slot);
                        if (!changed && entity.a(old, curr)) {
                            changed = true;
                        }
                        equipment.put(slot, curr);
                    }
                    if (changed) {
                        ArrayList vals = Lists.newArrayList();
                        for (EnumItemSlot slot : EnumItemSlot.values()) {
                            vals.add(Pair.of((Object)slot, (Object)((net.minecraft.world.item.ItemStack)equipment.get(slot))));
                        }
                        agg.send(new PacketPlayOutEntityEquipment(handle.af(), (List)vals));
                    }
                }
                tracker.a();
            }

            @Override
            public void unlink(Player player) {
                EntityPlayer p = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                tracker.a(p);
                linked.remove(p.b);
                agg.removeConnection(p.cs());
            }

            @Override
            public void unlinkAll(Consumer<Player> callback) {
                handle.a(Entity.RemovalReason.a);
                for (ServerPlayerConnection link : Lists.newArrayList((Iterable)linked)) {
                    CraftPlayer entity = link.f().getBukkitEntity();
                    this.unlink((Player)entity);
                    if (callback == null) continue;
                    callback.accept((Player)entity);
                }
                linked.clear();
            }
        };
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Throwable {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService sessionService = ((CraftServer)Bukkit.getServer()).getServer().am();
        if (!(sessionService instanceof YggdrasilMinecraftSessionService)) {
            return sessionService.fillProfileProperties(profile, requireSecure);
        }
        YggdrasilAuthenticationService auth = ((YggdrasilMinecraftSessionService)sessionService).getAuthenticationService();
        URL url = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UUIDTypeAdapter.fromUUID((UUID)profile.getId())));
        MinecraftProfilePropertiesResponse response = MAKE_REQUEST.invoke(auth, url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure)), null, MinecraftProfilePropertiesResponse.class);
        if (response == null) {
            return profile;
        }
        GameProfile result = new GameProfile(response.getId(), response.getName());
        result.getProperties().putAll((Multimap)response.getProperties());
        profile.getProperties().putAll((Multimap)response.getProperties());
        return result;
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return new CitizensBlockBreaker(entity, targetBlock, config);
    }

    public BossBar getBossBar(Entity entity) {
        BossBattleServer bserver = null;
        try {
            EnderDragonBattle df;
            if (entity.getType() == EntityType.WITHER) {
                bserver = ((EntityWither)NMSImpl.getHandle((Entity)entity)).cb;
            } else if (entity.getType() == EntityType.ENDER_DRAGON && (df = ((EntityEnderDragon)NMSImpl.getHandle(entity)).fQ()) != null) {
                bserver = df.k;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (bserver == null) {
            return null;
        }
        BossBar ret = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        try {
            CRAFT_BOSSBAR_HANDLE_FIELD.invoke(ret, bserver);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public BoundingBox getBoundingBox(Entity handle) {
        return NMSBoundingBox.wrap(NMSImpl.getHandle(handle).cD());
    }

    @Override
    public BoundingBox getCollisionBox(Object data) {
        return NMSBoundingBox.wrap(((CraftBlockData)data).getState().b((IBlockAccess)BlockAccessAir.a, BlockPosition.b, VoxelShapeCollision.a()).a());
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        VoxelShape shape = ((CraftBlock)block).getNMS().k((IBlockAccess)world, ((CraftBlock)block).getPosition());
        return shape.b() ? BoundingBox.EMPTY : NMSBoundingBox.wrap(shape.a());
    }

    @Override
    public Location getDestination(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        MobAI ai = MobAI.from(handle);
        if (ai == null) {
            return null;
        }
        ControllerMove controller = ai.getMoveControl();
        if (controller.b()) {
            return new Location(entity.getWorld(), controller.d(), controller.e(), controller.f());
        }
        if (ai.getNavigation().l()) {
            return null;
        }
        Vec3D vec = ai.getNavigation().j().a(handle);
        return new Location(entity.getWorld(), vec.a(), vec.b(), vec.c());
    }

    @Override
    public float getForwardBackwardMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bl;
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().ao();
    }

    @Override
    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)entity).ck();
    }

    @Override
    public EntityPacketTracker getPacketTracker(Entity entity) {
        WorldServer server = (WorldServer)NMSImpl.getHandle((Entity)entity).H;
        final PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)server.k().a.L.get(entity.getEntityId());
        if (entry == null) {
            return null;
        }
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                entry.b((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void run() {
            }

            @Override
            public void unlink(Player player) {
                entry.a((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void unlinkAll(Consumer<Player> callback) {
                entry.a();
            }
        };
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null || handle.r == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)handle.r, net.minecraft.world.entity.Entity::getBukkitEntity);
    }

    @Override
    public GameProfile getProfile(Player player) {
        return ((EntityHuman)NMSImpl.getHandle((LivingEntity)player)).fI();
    }

    @Override
    public GameProfile getProfile(SkullMeta meta) {
        if (SKULL_META_PROFILE == null && (SKULL_META_PROFILE = NMS.getFirstGetter(meta.getClass(), GameProfile.class)) == null) {
            return null;
        }
        try {
            return SKULL_META_PROFILE.invoke(meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public float getRidingHeightOffset(Entity entity, Entity mount) {
        return (float)NMSImpl.getHandle(mount).bv();
    }

    @Override
    public String getSoundPath(Sound flag) throws CommandException {
        try {
            SoundEffect effect = CraftSound.getSoundEffect((Sound)flag);
            if (effect == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return effect.a().a();
        }
        catch (Throwable e) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public Entity getSource(BlockCommandSender sender) {
        net.minecraft.world.entity.Entity source = ((CraftBlockCommandSender)sender).getWrapper().f();
        return source != null ? source.getBukkitEntity() : null;
    }

    @Override
    public float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (handle == null) {
            return 1.0f;
        }
        return (float)handle.c(GenericAttributes.d);
    }

    @Override
    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle(entity).dA();
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> nodes, NavigatorParameters params) {
        ArrayList list = Lists.newArrayList((Iterable)Iterables.transform(nodes, input -> new PathPoint(input.getBlockX(), input.getBlockY(), input.getBlockZ())));
        PathPoint last = list.size() > 0 ? (PathPoint)list.get(list.size() - 1) : null;
        PathEntity path = new PathEntity((List)list, last != null ? new BlockPosition(last.a, last.b, last.c) : null, true);
        return this.getTargetNavigator(entity, params, (NavigationAbstract input) -> input.a(path, (double)params.speedModifier()));
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location dest, NavigatorParameters params) {
        return this.getTargetNavigator(entity, params, (NavigationAbstract input) -> input.a(dest.getX(), dest.getY(), dest.getZ(), (double)params.speedModifier()));
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters params, final Function<NavigationAbstract, Boolean> function) {
        float oldWater;
        final net.minecraft.world.entity.Entity raw = NMSImpl.getHandle(entity);
        raw.c(true);
        final NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        float f = oldWater = raw instanceof MobAI ? ((MobAI)raw).getPathfindingMalus(PathType.j) : ((EntityInsentient)raw).a(PathType.j);
        if (params.avoidWater() && oldWater >= 0.0f) {
            if (raw instanceof MobAI) {
                ((MobAI)raw).setPathfindingMalus(PathType.j, oldWater + 1.0f);
            } else {
                ((EntityInsentient)raw).a(PathType.j, oldWater + 1.0f);
            }
        }
        navigation.p().b(params.hasExaminer(DoorExaminer.class));
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            private List<org.bukkit.block.Block> getBlocks(Entity entity2, PathEntity path) {
                ArrayList blocks = Lists.newArrayList();
                for (int i = 0; i < path.e(); ++i) {
                    PathPoint pp = path.a(i);
                    blocks.add(entity2.getWorld().getBlockAt(pp.a, pp.b, pp.c));
                }
                return blocks;
            }

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigation);
            }

            @Override
            public void stop() {
                PathEntity path = NMSImpl.getPathEntity(navigation);
                if (params.debug() && path != null) {
                    List<org.bukkit.block.Block> blocks = this.getBlocks(entity, path);
                    Util.sendBlockChanges(blocks, null);
                }
                if (oldWater >= 0.0f) {
                    if (raw instanceof MobAI) {
                        ((MobAI)raw).setPathfindingMalus(PathType.j, oldWater);
                    } else {
                        ((EntityInsentient)raw).a(PathType.j, oldWater);
                    }
                }
                navigation.n();
            }

            @Override
            public boolean update() {
                if (params.speedModifier() != this.lastSpeed) {
                    net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
                    EntitySize size = null;
                    try {
                        size = SIZE_FIELD_GETTER.invoke(handle);
                        if (handle instanceof EntityHorseAbstract) {
                            SIZE_FIELD_SETTER.invoke(handle, new EntitySize(Math.min(0.99f, size.a), size.b, false));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (!((Boolean)function.apply(navigation)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    try {
                        SIZE_FIELD_SETTER.invoke(handle, size);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (params.debug() && NMSImpl.getPathEntity(navigation) != null) {
                        Util.sendBlockChanges(this.getBlocks(entity, NMSImpl.getPathEntity(navigation)), Material.DANDELION);
                    }
                    this.lastSpeed = params.speedModifier();
                }
                navigation.a((double)params.speedModifier());
                return navigation.l();
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation == null ? null : new MCTargetNavigator(entity, navigation, target, parameters);
    }

    @Override
    public Entity getVehicle(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return null;
        }
        net.minecraft.world.entity.Entity e = handle.cV();
        return e == handle || e == null ? null : e.getBukkitEntity();
    }

    @Override
    public Collection<Player> getViewingPlayers(Entity entity) {
        WorldServer server = (WorldServer)NMSImpl.getHandle((Entity)entity).H;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)server.k().a.L.get(entity.getEntityId());
        return CitizensEntityTracker.getSeenBy(entry);
    }

    @Override
    public double getWidth(Entity entity) {
        return entity.getWidth();
    }

    @Override
    public float getXZMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.bj;
    }

    @Override
    public float getYaw(Entity entity) {
        return NMSImpl.getHandle(entity).dw();
    }

    @Override
    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle(entity).ax();
    }

    @Override
    public boolean isSneaking(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isSneaking();
        }
        return NMSImpl.getHandle(entity).al() == EntityPose.f;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block in) {
        IBlockData data = ((CraftBlock)in).getNMS();
        return data.o((IBlockAccess)((CraftWorld)in.getWorld()).getHandle(), new BlockPosition(in.getX(), in.getY(), in.getZ()));
    }

    @Override
    public boolean isValid(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle.valid && handle.bq();
    }

    @Override
    public void load(CommandManager manager) {
        this.registerTraitWithCommand(manager, BoatTrait.class);
        this.registerTraitWithCommand(manager, AreaEffectCloudTrait.class);
        this.registerTraitWithCommand(manager, EnderDragonTrait.class);
        this.registerTraitWithCommand(manager, AllayTrait.class);
        this.registerTraitWithCommand(manager, AxolotlTrait.class);
        this.registerTraitWithCommand(manager, BeeTrait.class);
        this.registerTraitWithCommand(manager, BossBarTrait.class);
        this.registerTraitWithCommand(manager, CamelTrait.class);
        this.registerTraitWithCommand(manager, CatTrait.class);
        this.registerTraitWithCommand(manager, DisplayTrait.class);
        this.registerTraitWithCommand(manager, FoxTrait.class);
        this.registerTraitWithCommand(manager, FrogTrait.class);
        this.registerTraitWithCommand(manager, GoatTrait.class);
        this.registerTraitWithCommand(manager, LlamaTrait.class);
        this.registerTraitWithCommand(manager, MushroomCowTrait.class);
        this.registerTraitWithCommand(manager, ParrotTrait.class);
        this.registerTraitWithCommand(manager, PandaTrait.class);
        this.registerTraitWithCommand(manager, PiglinTrait.class);
        this.registerTraitWithCommand(manager, PhantomTrait.class);
        this.registerTraitWithCommand(manager, PolarBearTrait.class);
        this.registerTraitWithCommand(manager, PufferFishTrait.class);
        this.registerTraitWithCommand(manager, SpellcasterTrait.class);
        this.registerTraitWithCommand(manager, ShulkerTrait.class);
        this.registerTraitWithCommand(manager, SnowmanTrait.class);
        this.registerTraitWithCommand(manager, VexTrait.class);
        this.registerTraitWithCommand(manager, TextDisplayTrait.class);
        this.registerTraitWithCommand(manager, TropicalFishTrait.class);
        this.registerTraitWithCommand(manager, VillagerTrait.class);
        this.registerTraitWithCommand(manager, WardenTrait.class);
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.ALLAY, AllayController.class);
        EntityControllers.setEntityControllerForType(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.AXOLOTL, AxolotlController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BEE, BeeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAT, CatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAMEL, CamelController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHEST_BOAT, ChestBoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COD, CodController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.DOLPHIN, DolphinController.class);
        EntityControllers.setEntityControllerForType(EntityType.DRAGON_FIREBALL, DragonFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROPPED_ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROWNED, DrownedController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ELDER_GUARDIAN, GuardianElderController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_SIGNAL, EnderSignalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER, EvokerController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER_FANGS, EvokerFangsController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_HOOK, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.FOX, FoxController.class);
        EntityControllers.setEntityControllerForType(EntityType.FROG, FrogController.class);
        EntityControllers.setEntityControllerForType(EntityType.TADPOLE, TadpoleController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GOAT, GoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.DONKEY, HorseDonkeyController.class);
        EntityControllers.setEntityControllerForType(EntityType.MULE, HorseMuleController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON_HORSE, HorseSkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_HORSE, HorseZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.HUSK, ZombieHuskController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ILLUSIONER, IllusionerController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_ITEM_FRAME, GlowItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_HITCH, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA, LlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA_SPIT, LlamaSpitController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRADER_LLAMA, TraderLlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.WANDERING_TRADER, WanderingTraderController.class);
        EntityControllers.setEntityControllerForType(EntityType.MARKER, MarkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_CHEST, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_COMMAND, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_FURNACE, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_HOPPER, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_TNT, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_MOB_SPAWNER, MinecartSpawnerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MUSHROOM_COW, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PANDA, PandaController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PARROT, ParrotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PHANTOM, PhantomController.class);
        EntityControllers.setEntityControllerForType(EntityType.PILLAGER, PillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN, PiglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN_BRUTE, PiglinBruteController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOGLIN, HoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIFIED_PIGLIN, PigZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOGLIN, ZoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.POLAR_BEAR, PolarBearController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.PUFFERFISH, PufferFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.RAVAGER, RavagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SALMON, SalmonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER, ShulkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER_BULLET, ShulkerBulletController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRAY, SkeletonStrayController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRIDER, StriderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWMAN, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPLASH_POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_ORB, ExperienceOrbController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_SQUID, GlowSquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.THROWN_EXP_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRIDENT, ThrownTridentController.class);
        EntityControllers.setEntityControllerForType(EntityType.TROPICAL_FISH, TropicalFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.TURTLE, TurtleController.class);
        EntityControllers.setEntityControllerForType(EntityType.PRIMED_TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.VEX, VexController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.VINDICATOR, VindicatorController.class);
        EntityControllers.setEntityControllerForType(EntityType.WARDEN, WardenController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKELETON, SkeletonWitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_VILLAGER, ZombieVillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNIFFER, SnifferController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLOCK_DISPLAY, BlockDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.TEXT_DISPLAY, TextDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_DISPLAY, ItemDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.INTERACTION, InteractionController.class);
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        yaw = Util.clamp(yaw);
        handle.f(yaw);
        this.setHeadYaw(entity, yaw);
        handle.e(pitch);
    }

    @Override
    public void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof MobAI)) {
            double pitch;
            double yaw;
            Location fromLocation = entity.getLocation(FROM_LOCATION);
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double d = yaw = distanceXZ == 0.0 ? 0.0 : Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double d2 = distanceY == 0.0 ? 0.0 : (pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - (double)(handle.getBukkitEntity().getType() == EntityType.PHANTOM ? 45 : 90));
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw = handle.getBukkitEntity().getType() == EntityType.ENDER_DRAGON ? (double)Util.getYawFromVelocity((Entity)handle.getBukkitEntity(), xDiff, zDiff) : (yaw -= 90.0);
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.look(entity, (float)yaw, (float)pitch);
            }
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).C().a(to.getX(), to.getY(), to.getZ(), (float)((EntityInsentient)handle).X(), (float)((EntityInsentient)handle).V());
            while (((EntityLiving)handle).aV >= 180.0f) {
                ((EntityLiving)handle).aV -= 360.0f;
            }
            while (((EntityLiving)handle).aV < -180.0f) {
                ((EntityLiving)handle).aV += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void look(Entity from, Entity to) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        net.minecraft.world.entity.Entity target = NMSImpl.getHandle(to);
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof MobAI)) {
            if (to instanceof LivingEntity) {
                this.look(from, ((LivingEntity)to).getEyeLocation(), false, true);
            } else {
                this.look(from, to.getLocation(), false, true);
            }
        } else if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).C().a(target, (float)((EntityInsentient)handle).X(), (float)((EntityInsentient)handle).V());
            while (((EntityLiving)handle).aV >= 180.0f) {
                ((EntityLiving)handle).aV -= 360.0f;
            }
            while (((EntityLiving)handle).aV < -180.0f) {
                ((EntityLiving)handle).aV += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void markPoseDirty(Entity entity) {
        NMSImpl.getHandle(entity).aj().markDirty(DATA_POSE);
    }

    @Override
    public void mount(Entity entity, Entity passenger) {
        if (NMSImpl.getHandle(passenger) == null) {
            return;
        }
        NMSImpl.getHandle(passenger).a(NMSImpl.getHandle(entity), true);
    }

    @Override
    public void onPlayerInfoAdd(Player player, Object raw, Function<UUID, MirrorTrait> mirrorTraits) {
        ClientboundPlayerInfoUpdatePacket packet = (ClientboundPlayerInfoUpdatePacket)raw;
        ArrayList list = Lists.newArrayList((Iterable)packet.c());
        boolean changed = false;
        GameProfile playerProfile = null;
        for (int i = 0; i < list.size(); ++i) {
            MirrorTrait trait;
            ClientboundPlayerInfoUpdatePacket.b npcInfo = (ClientboundPlayerInfoUpdatePacket.b)list.get(i);
            if (npcInfo == null || (trait = mirrorTraits.apply(npcInfo.a())) == null || !trait.isMirroring(player)) continue;
            boolean disableTablist = trait.getNPC().shouldRemoveFromTabList();
            if (disableTablist != npcInfo.c()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.b(npcInfo.a(), npcInfo.b(), !disableTablist, npcInfo.d(), npcInfo.e(), (IChatBaseComponent)(!disableTablist ? npcInfo.f() : IChatBaseComponent.h()), npcInfo.g()));
                changed = true;
            }
            if (playerProfile == null) {
                playerProfile = NMS.getProfile(player);
            }
            if (trait.mirrorName()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.b(npcInfo.a(), playerProfile, !disableTablist, npcInfo.d(), npcInfo.e(), (IChatBaseComponent)IChatBaseComponent.b((String)Util.possiblyStripBedrockPrefix(playerProfile.getName(), playerProfile.getId())), npcInfo.g()));
                changed = true;
                continue;
            }
            Collection textures = playerProfile.getProperties().get((Object)"textures");
            if (textures == null || textures.size() == 0) continue;
            npcInfo.b().getProperties().clear();
            for (String key : playerProfile.getProperties().keySet()) {
                npcInfo.b().getProperties().putAll((Object)key, (Iterable)playerProfile.getProperties().get((Object)key));
            }
            changed = true;
        }
        if (changed) {
            try {
                PLAYER_INFO_ENTRIES_LIST.invoke(packet, list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InventoryView openAnvilInventory(Player player, final Inventory anvil, String title) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ContainerAnvil container = new ContainerAnvil(handle.nextContainerCounter(), handle.fJ(), ContainerAccess.a((net.minecraft.world.level.World)handle.H, (BlockPosition)new BlockPosition(0, 0, 0))){
            private CraftInventoryView bukkitEntity;

            protected void a(EntityHuman entityhuman, IInventory iinventory) {
            }

            public void m() {
                super.m();
                this.w.a(0);
            }

            public CraftInventoryView getBukkitView() {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.p.getBukkitEntity(), (Inventory)new CitizensInventoryAnvil(this.o.getLocation(), this.q, (IInventory)this.r, this, anvil), (Container)this);
                }
                return this.bukkitEntity;
            }
        };
        container.setTitle((IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents(title == null ? "" : title)));
        container.getBukkitView().setItem(0, anvil.getItem(0));
        container.getBukkitView().setItem(1, anvil.getItem(1));
        container.checkReachable = false;
        handle.b.a((Packet)new PacketPlayOutOpenWindow(container.j, container.a(), container.getTitle()));
        handle.bP = container;
        handle.a((Container)container);
        return container.getBukkitView();
    }

    @Override
    public void openHorseInventory(Tameable horse, Player equipper) {
        EntityLiving handle = NMSImpl.getHandle(horse);
        EntityPlayer equipperHandle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((EntityHorseAbstract)handle).b((EntityHuman)equipperHandle);
        horse.setTamed(wasTamed);
    }

    @Override
    public void playAnimation(PlayerAnimation animation, Player player, Iterable<Player> to) {
        PlayerAnimationImpl.play(animation, player, to);
    }

    @Override
    public Runnable playerTicker(NPC npc, Player entity) {
        EntityPlayer player = (EntityPlayer)NMSImpl.getHandle((LivingEntity)entity);
        return () -> {
            if (!entity.isValid()) {
                return;
            }
            player.m();
        };
    }

    @Override
    public void positionInteractionText(Player player, Entity entity, Entity mount, double offset) {
        NMSImpl.sendPacket(player, new ClientboundBundlePacket(List.of(new PacketPlayOutEntityMetadata(entity.getEntityId(), List.of(new DataWatcher.Item(INTERACTION_WIDTH, (Object)Float.valueOf(0.0f)).e(), new DataWatcher.Item(INTERACTION_HEIGHT, (Object)Float.valueOf((float)(offset += (double)this.getRidingHeightOffset(entity, mount) + 0.5))).e(), new DataWatcher.Item(DATA_POSE, (Object)EntityPose.i).e(), new DataWatcher.Item(DATA_NAME_VISIBLE, (Object)true).e())), new PacketPlayOutMount(NMSImpl.getHandle(mount)), new PacketPlayOutEntityMetadata(entity.getEntityId(), List.of(new DataWatcher.Item(INTERACTION_HEIGHT, (Object)Float.valueOf(999999.0f)).e())))));
    }

    @Override
    public void registerEntityClass(Class<?> clazz, Object raw) {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.world.entity.Entity.class.isAssignableFrom(search)) {
            EntityTypes type = ENTITY_REGISTRY.findType(search);
            MinecraftKey key = ENTITY_REGISTRY.getKey(type);
            if (key == null || type == null) continue;
            CITIZENS_ENTITY_TYPES.put(clazz, type);
            int code = ENTITY_REGISTRY.getId(type);
            ENTITY_REGISTRY.put(code, key, type);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    private void registerTraitWithCommand(CommandManager manager, Class<? extends Trait> clazz) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(clazz));
        manager.register(clazz);
    }

    @Override
    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).a(Entity.RemovalReason.a);
    }

    @Override
    public void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().k.remove(handle);
    }

    @Override
    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        ((WorldServer)nmsEntity.H).k().a(nmsEntity);
    }

    @Override
    public void removeHookIfNecessary(FishHook entity) {
        EntityFishingHook hook = (EntityFishingHook)NMSImpl.getHandle((Entity)entity);
        net.minecraft.world.entity.Entity hooked = hook.k();
        if (hooked == null) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)hooked.getBukkitEntity());
        if (npc != null && npc.isProtected()) {
            hook.o = null;
            hook.getBukkitEntity().remove();
        }
    }

    @Override
    public void replaceTrackerEntry(Entity entity) {
        WorldServer server = (WorldServer)NMSImpl.getHandle((Entity)entity).H;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)server.k().a.L.get(entity.getEntityId());
        if (entry == null) {
            return;
        }
        entry.a();
        CitizensEntityTracker replace = new CitizensEntityTracker(server.k().a, entry);
        server.k().a.L.put(entity.getEntityId(), (Object)replace);
    }

    @Override
    public void sendPositionUpdate(Entity from, Collection<Player> to, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        List<Packet<?>> toSend = NMSImpl.getPositionUpdate(from, position, bodyYaw, pitch, headYaw);
        for (Player dest : to) {
            NMSImpl.sendPackets(dest, toSend);
        }
    }

    @Override
    public boolean sendTabListAdd(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer from = ((CraftPlayer)listPlayer).getHandle();
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(Arrays.asList(from));
        boolean list = from instanceof NPCHolder ? !((NPCHolder)from).getNPC().shouldRemoveFromTabList() : true;
        ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(from.cs(), from.fI(), list, from.e, from.d.b(), (IChatBaseComponent)(list ? from.J() : IChatBaseComponent.h()), from.X() == null ? null : from.X().b());
        try {
            PLAYERINFO_ENTRIES.invoke(packet, Lists.newArrayList((Object[])new ClientboundPlayerInfoUpdatePacket.b[]{entry}));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        NMSImpl.sendPacket(recipient, packet);
        return true;
    }

    @Override
    public void sendTabListRemove(Player recipient, Collection<Player> skinnableNPCs) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull(skinnableNPCs);
        NMSImpl.sendPacket(recipient, new ClientboundPlayerInfoRemovePacket(skinnableNPCs.stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toList())));
    }

    @Override
    public void sendTeamPacket(Player recipient, Team team, int mode) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getGetter(team.getClass(), "team");
        }
        try {
            ScoreboardTeam nmsTeam = TEAM_FIELD.invoke(team);
            if (mode == 1) {
                NMSImpl.sendPacket(recipient, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)nmsTeam));
            } else {
                NMSImpl.sendPacket(recipient, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)nmsTeam, (mode == 0 ? 1 : 0) != 0));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAggressive(Entity entity, boolean aggro) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)handle).v(aggro);
    }

    @Override
    public void setAllayDancing(Entity entity, boolean dancing) {
        Allay allay = (Allay)NMSImpl.getHandle(entity);
        allay.w(dancing);
    }

    @Override
    public void setBodyYaw(Entity entity, float yaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aU = yaw;
        }
        handle.s(yaw);
        handle.f(yaw);
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox box) {
        NMSImpl.getHandle(entity).a(NMSBoundingBox.convert(box));
    }

    @Override
    public void setCamelPose(Entity entity, CamelTrait.CamelPose pose) {
        if (entity.getType() != EntityType.CAMEL) {
            throw new IllegalStateException();
        }
        Camel camel = (Camel)NMSImpl.getHandle(entity);
        switch (pose) {
            case STANDING: {
                if (!camel.gl()) {
                    camel.ge();
                }
                return;
            }
            case SITTING: {
                if (!camel.ga()) {
                    camel.gd();
                }
                return;
            }
            case PANIC: {
                if (!camel.fS()) {
                    camel.gf();
                }
                return;
            }
        }
    }

    @Override
    public void setCustomName(Entity entity, Object component, String string) {
        NMSImpl.getHandle(entity).b((IChatBaseComponent)component);
    }

    @Override
    public void setDestination(Entity entity, double x, double y, double z, float speed) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getMoveControl().a(x, y, z, (double)speed);
        }
    }

    @Override
    public void setDimensions(Entity entity, EntityDim desired) {
        NMSImpl.setSize(NMSImpl.getHandle(entity), new EntitySize(desired.width, desired.height, true));
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean angry) {
        if (ENDERMAN_CREEPY == null) {
            return;
        }
        NMSImpl.getHandle((LivingEntity)enderman).aj().b(ENDERMAN_CREEPY, (Object)angry);
    }

    @Override
    public void setHeadAndBodyYaw(Entity entity, float yaw) {
        if (!(entity instanceof LivingEntity)) {
            NMSImpl.getHandle(entity).f(yaw);
            return;
        }
        EntityLiving handle = (EntityLiving)NMSImpl.getHandle(entity);
        handle.aU = yaw = Util.clamp(yaw);
        if (!(handle instanceof EntityHuman)) {
            handle.s(yaw);
        }
        this.setHeadYaw(entity, yaw);
    }

    @Override
    public void setHeadYaw(Entity entity, float yaw) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((EntityLiving)NMSImpl.getHandle(entity)).r(Util.clamp(yaw));
    }

    @Override
    public void setKnockbackResistance(LivingEntity entity, double d) {
        EntityLiving handle = NMSImpl.getHandle(entity);
        handle.a(GenericAttributes.c).a(d);
    }

    @Override
    public void setLocationDirectly(Entity entity, Location location) {
        NMSImpl.getHandle(entity).b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setLyingDown(Entity cat, boolean lying) {
        ((EntityCat)NMSImpl.getHandle(cat)).A(lying);
    }

    @Override
    public void setNavigationTarget(Entity handle, Entity target, float speed) {
        NMSImpl.getNavigation(handle).a(NMSImpl.getHandle(target), (double)speed);
    }

    @Override
    public void setNavigationType(Entity entity, NMS.MinecraftNavigationType type) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient ei = (EntityInsentient)handle;
        switch (type) {
            case GROUND: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new Navigation(ei, ei.H));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            case WALL_CLIMB: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new NavigationSpider(ei, ei.H));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setNoGravity(Entity entity, boolean nogravity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        handle.e(nogravity);
        if (!(handle instanceof EntityInsentient) || !(entity instanceof NPCHolder)) {
            return;
        }
        EntityInsentient mob = (EntityInsentient)handle;
        NPC npc = ((NPCHolder)entity).getNPC();
        if (!(mob.D() instanceof ControllerMoveFlying) || npc.data().has("flying-nogravity-float")) {
            return;
        }
        try {
            if (nogravity) {
                boolean old = FLYING_MOVECONTROL_FLOAT_GETTER.invoke(mob.D());
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.D(), true);
                npc.data().set("flying-nogravity-float", (Object)old);
            } else if (npc.data().has("flying-nogravity-float")) {
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.D(), npc.data().get("flying-nogravity-float"));
                npc.data().remove("flying-nogravity-float");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setOpWithoutSaving(Player player, boolean op) {
        if (player.isOp() == op) {
            return;
        }
        EntityPlayer playerHandle = ((CraftPlayer)player).getHandle();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        DedicatedPlayerList playerList = ((CraftServer)player.getServer()).getHandle();
        DedicatedServer server = playerList.b();
        OpList opList = playerList.k();
        if (op) {
            opList.a((JsonListEntry)new OpListEntry(profile, server.i(), opList.a(profile)));
        } else {
            opList.c((Object)profile);
        }
        playerList.d(playerHandle);
    }

    @Override
    public void setPandaSitting(Entity entity, boolean sitting) {
        ((EntityPanda)NMSImpl.getHandle(entity)).w(sitting);
    }

    @Override
    public void setPeekShulker(Entity shulker, int peek) {
        ((EntityShulker)NMSImpl.getHandle(shulker)).b(peek);
    }

    @Override
    public void setPiglinDancing(Entity entity, boolean dancing) {
        if (!(NMSImpl.getHandle(entity) instanceof EntityPiglin)) {
            return;
        }
        ((EntityPiglin)NMSImpl.getHandle(entity)).x(dancing);
    }

    @Override
    public void setPitch(Entity entity, float pitch) {
        NMSImpl.getHandle(entity).e(pitch);
    }

    @Override
    public void setPolarBearRearing(Entity entity, boolean rearing) {
        ((EntityPolarBear)NMSImpl.getHandle(entity)).w(rearing);
    }

    @Override
    public void setPose(Entity entity, EntityPoseTrait.EntityPose pose) {
        NMSImpl.getHandle(entity).b(EntityPose.valueOf((String)pose.name()));
    }

    @Override
    public void setProfile(SkullMeta meta, GameProfile profile) {
        if (SET_PROFILE_METHOD == null && (SET_PROFILE_METHOD = NMS.getMethodHandle(meta.getClass(), "setProfile", true, GameProfile.class)) == null) {
            return;
        }
        try {
            SET_PROFILE_METHOD.invoke(meta, profile);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setShouldJump(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getJumpControl().a();
        }
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).r(true);
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean sitting) {
        this.setSneaking((Entity)ocelot, sitting);
    }

    @Override
    public void setSitting(Tameable tameable, boolean sitting) {
        ((EntityTameableAnimal)NMSImpl.getHandle(tameable)).y(sitting);
    }

    @Override
    public void setSneaking(Entity entity, boolean sneaking) {
        if (entity instanceof Player) {
            ((Player)entity).setSneaking(sneaking);
        }
        EntityPose pose = sneaking ? EntityPose.f : EntityPose.a;
        NMSImpl.getHandle(entity).b(pose);
    }

    @Override
    public void setSnifferState(Entity entity, SnifferTrait.SnifferState state) {
        Sniffer handle = (Sniffer)NMSImpl.getHandle(entity);
        handle.a(Sniffer.a.valueOf((String)state.name()));
    }

    @Override
    public void setStepHeight(Entity entity, float height) {
        NMSImpl.getHandle(entity).v(height);
    }

    @Override
    public void setTextDisplayComponent(Entity entity, Object component) {
        Display.TextDisplay disp = (Display.TextDisplay)NMSImpl.getHandle(entity);
        disp.c((IChatBaseComponent)component);
    }

    @Override
    public void setVerticalMovement(Entity bukkitEntity, double d) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)bukkitEntity);
        handle.bj = (float)d;
    }

    @Override
    public void setWardenPose(Entity entity, Object pose) {
        Warden warden = (Warden)NMSImpl.getHandle(entity);
        if (pose == Pose.DIGGING) {
            if (warden.c(EntityPose.o)) {
                return;
            }
            warden.b(EntityPose.o);
            warden.a(SoundEffects.zb, 5.0f, 1.0f);
        } else if (pose == Pose.EMERGING) {
            if (warden.c(EntityPose.n)) {
                return;
            }
            warden.b(EntityPose.n);
            warden.a(SoundEffects.zc, 5.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.c(EntityPose.n)) {
                    warden.b(EntityPose.a);
                }
            }, 134L);
        } else if (pose == Pose.ROARING) {
            if (warden.c(EntityPose.l)) {
                return;
            }
            warden.b(EntityPose.l);
            warden.a(SoundEffects.zk, 3.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.c(EntityPose.l)) {
                    warden.b(EntityPose.a);
                }
            }, 84L);
        } else {
            warden.b(EntityPose.a);
        }
    }

    @Override
    public void setWitherInvulnerableTicks(Wither wither, int ticks) {
        EntityWither handle = ((CraftWither)wither).getHandle();
        handle.r(ticks);
    }

    @Override
    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.invoke(NMSImpl.getHandle(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        try {
            ENTITY_REGISTRY_SETTER.invoke(null, ENTITY_REGISTRY.get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sleep(Player entity, boolean sleep) {
        NMSImpl.getHandle((LivingEntity)entity).b(sleep ? EntityPose.c : EntityPose.a);
    }

    @Override
    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(Entity entity, float power) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (RANDOM.nextFloat() <= 0.85f && handle.aT()) {
            handle.o(handle.dj().c, handle.dj().d + (double)power, handle.dj().e);
        }
    }

    @Override
    public void updateInventoryTitle(Player player, SpigotUtil.InventoryViewAPI view, String newTitle) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        Containers menuType = null;
        switch (view.getTopInventory().getType()) {
            case ANVIL: {
                menuType = Containers.h;
                break;
            }
            case BARREL: {
                menuType = Containers.c;
                break;
            }
            case BEACON: {
                menuType = Containers.i;
                break;
            }
            case BLAST_FURNACE: {
                menuType = Containers.j;
                break;
            }
            case BREWING: {
                menuType = Containers.k;
                break;
            }
            case CARTOGRAPHY: {
                menuType = Containers.x;
                break;
            }
            case CHEST: {
                int sz = view.getTopInventory().getSize();
                if (sz > 45) {
                    menuType = Containers.f;
                    break;
                }
                if (sz > 36) {
                    menuType = Containers.e;
                    break;
                }
                if (sz > 27) {
                    menuType = Containers.d;
                    break;
                }
                if (sz > 18) {
                    menuType = Containers.c;
                    break;
                }
                if (sz > 9) {
                    menuType = Containers.b;
                    break;
                }
                menuType = Containers.a;
                break;
            }
            case COMPOSTER: {
                break;
            }
            case PLAYER: 
            case CRAFTING: 
            case CREATIVE: {
                return;
            }
            case DISPENSER: 
            case DROPPER: {
                menuType = Containers.g;
                break;
            }
            case ENCHANTING: {
                menuType = Containers.m;
                break;
            }
            case ENDER_CHEST: {
                menuType = Containers.c;
                break;
            }
            case FURNACE: {
                menuType = Containers.n;
                break;
            }
            case GRINDSTONE: {
                menuType = Containers.o;
                break;
            }
            case HOPPER: {
                menuType = Containers.p;
                break;
            }
            case LECTERN: {
                menuType = Containers.q;
                break;
            }
            case LOOM: {
                menuType = Containers.r;
                break;
            }
            case MERCHANT: {
                menuType = Containers.s;
                break;
            }
            case SHULKER_BOX: {
                menuType = Containers.t;
                break;
            }
            case SMITHING: {
                menuType = Containers.v;
                break;
            }
            case SMOKER: {
                menuType = Containers.w;
                break;
            }
            case STONECUTTER: {
                menuType = Containers.y;
                break;
            }
            case WORKBENCH: {
                menuType = Containers.l;
            }
        }
        handle.b.a((Packet)new PacketPlayOutOpenWindow(handle.bP.j, menuType, (IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents(newTitle))));
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.world.entity.Entity en = NMSImpl.getHandle(entity);
        if (en == null || !(en instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.invoke(handle.G(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving en = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (en instanceof MobAI) {
            ((MobAI)en).updatePathfindingRange(pathfindingRange);
            return;
        }
        if (NAVIGATION_PATHFINDER == null) {
            return;
        }
        NavigationAbstract navigation = ((EntityInsentient)en).G();
        AttributeModifiable inst = en.a(GenericAttributes.b);
        inst.a((double)pathfindingRange);
        int mc = MathHelper.a((double)(en.c(GenericAttributes.b) * 16.0));
        try {
            NAVIGATION_PATHFINDER.invoke(navigation, NAVIGATION_CREATE_PATHFINDER.invoke(navigation, mc));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static <T extends net.minecraft.world.entity.Entity> void callNPCMoveEvent(T what) {
        NPC npc = ((NPCHolder)what).getNPC();
        if (npc != null && NPCMoveEvent.getHandlerList().getRegisteredListeners().length > 0 && (what.I != what.dl() || what.J != what.dn() || what.K != what.dr() || what.L != what.dw() || what.M != what.dy())) {
            Location from = new Location((World)what.H.getWorld(), what.I, what.J, what.K, what.L, what.M);
            Location to = new Location((World)what.H.getWorld(), what.dl(), what.dn(), what.dr(), what.dw(), what.dy());
            NPCMoveEvent event = new NPCMoveEvent(npc, from, to.clone());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                Location eventFrom = event.getFrom();
                what.a(eventFrom.getX(), eventFrom.getY(), eventFrom.getZ(), eventFrom.getYaw(), eventFrom.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                what.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
    }

    public static void checkAndUpdateHeight(EntityLiving living, DataWatcherObject<?> datawatcherobject, Consumer<DataWatcherObject<?>> cb) {
        EntitySize size;
        try {
            size = SIZE_FIELD_GETTER.invoke(living);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        float oldw = size.a;
        float oldl = size.b;
        cb.accept(datawatcherobject);
        if (oldw != size.a || size.b != oldl) {
            living.e(living.dl() - 0.01, living.dn(), living.dr() - 0.01);
            living.e(living.dl() + 0.01, living.dn(), living.dr() + 0.01);
        }
    }

    public static void clearGoals(NPC npc, PathfinderGoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                Set list = selector.b();
                if (!list.isEmpty()) {
                    npc.data().set("selector" + i, (Object)Lists.newArrayList((Iterable)list));
                }
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    public static void flyingMoveLogic(EntityLiving entity, Vec3D vec3d) {
        if (entity.cU() || entity.cT()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = entity.dj().d <= 0.0;
            if (flag && entity.a(MobEffects.B)) {
                d0 = 0.01;
                entity.aa = 0.0f;
            }
            Fluid fluid = entity.H.b_(entity.dg());
            if (entity.aT() && !entity.a(fluid)) {
                double d1 = entity.dn();
                float f = entity.bU() ? 0.9f : 0.8f;
                float f1 = 0.02f;
                float f2 = EnchantmentManager.f((EntityLiving)entity);
                if (f2 > 3.0f) {
                    f2 = 3.0f;
                }
                if (!entity.ax()) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f += (0.546f - f) * f2 / 3.0f;
                    f1 += (entity.eW() - f1) * f2 / 3.0f;
                }
                if (entity.a(MobEffects.D)) {
                    f = 0.96f;
                }
                entity.a(f1, vec3d);
                entity.a(EnumMoveType.a, entity.dj());
                Vec3D vec3d1 = entity.dj();
                if (entity.O && entity.z_()) {
                    vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
                }
                entity.f(vec3d1.d((double)f, 0.8, (double)f));
                Vec3D vec3d2 = entity.a(d0, flag, entity.dj());
                entity.f(vec3d2);
                if (entity.O && entity.g(vec3d2.c, vec3d2.d + 0.6 - entity.dn() + d1, vec3d2.e)) {
                    entity.o(vec3d2.c, 0.3, vec3d2.e);
                }
            } else if (entity.bg() && !entity.a(fluid)) {
                double d1 = entity.dn();
                entity.a(0.02f, vec3d);
                entity.a(EnumMoveType.a, entity.dj());
                if (entity.b(TagsFluid.b) <= entity.db()) {
                    entity.f(entity.dj().d(0.5, 0.8, 0.5));
                    Vec3D vec3 = entity.a(d0, flag, entity.dj());
                    entity.f(vec3);
                } else {
                    entity.f(entity.dj().a(0.5));
                }
                if (!entity.aP()) {
                    entity.f(entity.dj().b(0.0, -d0 / 4.0, 0.0));
                }
                Vec3D vec3d3 = entity.dj();
                if (entity.O && entity.g(vec3d3.c, vec3d3.d + 0.6 - entity.dn() + d1, vec3d3.e)) {
                    entity.o(vec3d3.c, 0.3, vec3d3.e);
                }
            } else if (entity.fn()) {
                double d6;
                float f4;
                double d5;
                Vec3D vec3d4 = entity.dj();
                if (vec3d4.d > -0.5) {
                    entity.aa = 1.0f;
                }
                Vec3D vec3d5 = entity.bC();
                float f = entity.dy() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.c * vec3d5.c + vec3d5.e * vec3d5.e);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                float f3 = MathHelper.b((float)f);
                f3 = (float)((double)(f3 * f3) * Math.min(1.0, d4 / 0.4));
                vec3d4 = entity.dj().b(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
                if (vec3d4.d < 0.0 && d2 > 0.0) {
                    d5 = vec3d4.d * -0.1 * (double)f3;
                    vec3d4 = vec3d4.b(vec3d5.c * d5 / d2, d5, vec3d5.e * d5 / d2);
                }
                if (f < 0.0f && d2 > 0.0) {
                    d5 = d3 * (double)(-MathHelper.a((float)f)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.c * d5 / d2, d5 * 3.2, -vec3d5.e * d5 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.c / d2 * d3 - vec3d4.c) * 0.1, 0.0, (vec3d5.e / d2 * d3 - vec3d4.e) * 0.1);
                }
                entity.f(vec3d4.d(0.99, 0.98, 0.99));
                entity.a(EnumMoveType.a, entity.dj());
                if (entity.O && !entity.H.B && (f4 = (float)((d6 = d3 - (d5 = entity.dj().h())) * 10.0 - 3.0)) > 0.0f) {
                    entity.a(entity.getFallDamageSound0((int)f4), 1.0f, 1.0f);
                    entity.a(entity.dG().l(), f4);
                }
                if (entity.ax() && !entity.H.B && entity.h(7) && !CraftEventFactory.callToggleGlideEvent((EntityLiving)entity, (boolean)false).isCancelled()) {
                    entity.b(7, false);
                }
            } else {
                BlockPosition blockposition = BlockPosition.a((double)entity.dl(), (double)(entity.cD().b - 0.5), (double)entity.dr());
                float f5 = entity.H.a_(blockposition).b().i();
                float f = entity.ax() ? f5 * 0.91f : 0.91f;
                Vec3D vec3d6 = entity.a(vec3d, f5);
                double d7 = vec3d6.d;
                if (entity.a(MobEffects.y)) {
                    d7 += (0.05 * (double)(entity.b(MobEffects.y).e() + 1) - vec3d6.d) * 0.2;
                    entity.aa = 0.0f;
                } else if (entity.H.B && !entity.H.D(blockposition)) {
                    d7 = entity.dn() > (double)entity.H.v_() ? -0.1 : 0.0;
                } else if (!entity.aP()) {
                    d7 -= d0;
                }
                if (entity.ef()) {
                    entity.o(vec3d6.c, d7, vec3d6.e);
                } else {
                    entity.o(vec3d6.c * (double)f, d7 * 0.98, vec3d6.e * (double)f);
                }
            }
        }
        entity.q(entity instanceof EntityBird);
    }

    public static TreeMap<?, ?> getBehaviorMap(EntityLiving entity) {
        try {
            return BEHAVIOR_TREE_MAP.invoke(entity.dH());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends net.minecraft.world.entity.Entity> EntityTypes<T> getEntityType(Class<?> clazz) {
        return CITIZENS_ENTITY_TYPES.get(clazz);
    }

    public static net.minecraft.world.entity.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    private static EntityLiving getHandle(LivingEntity entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    private static EntityLiving getHandle(Tameable entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    public static NavigationAbstract getNavigation(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof EntityInsentient ? ((EntityInsentient)handle).G() : (handle instanceof MobAI ? ((MobAI)handle).getNavigation() : null);
    }

    private static PathEntity getPathEntity(NavigationAbstract nav) {
        try {
            return nav instanceof EntityNavigation ? ((EntityNavigation)nav).getPathEntity() : NAVIGATION_PATH.invoke(nav);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Packet<?>> getPositionUpdate(Entity from, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        if (bodyYaw == null) {
            bodyYaw = Float.valueOf(handle.dw());
        }
        if (pitch == null) {
            pitch = Float.valueOf(handle.dy());
        }
        ArrayList toSend = Lists.newArrayList();
        if (position) {
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)((WorldServer)handle.H).k().a.L.get(handle.af());
            VecDeltaCodec vdc = null;
            try {
                vdc = POSITION_CODEC_GETTER.invoke(SERVER_ENTITY_GETTER.invoke(entry));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
            Vec3D pos = handle.df();
            toSend.add(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(handle.af(), (short)vdc.a(pos), (short)vdc.b(pos), (short)vdc.c(pos), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.N));
        } else {
            toSend.add(new PacketPlayOutEntity.PacketPlayOutEntityLook(handle.af(), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.N));
        }
        if (headYaw != null) {
            toSend.add(new PacketPlayOutEntityHeadRotation(handle, (byte)(headYaw.floatValue() * 256.0f / 360.0f)));
        }
        return toSend;
    }

    public static DataWatcherObject<Integer> getRabbitTypeField() {
        return RABBIT_TYPE_DATAWATCHER;
    }

    public static EntitySize getSize(net.minecraft.world.entity.Entity entity) {
        try {
            return SIZE_FIELD_GETTER.invoke(entity);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoundEffect getSoundEffect(NPC npc, SoundEffect snd, NPC.Metadata meta) {
        if (npc == null) {
            return snd;
        }
        String data = (String)npc.data().get(meta);
        return data == null ? snd : (SoundEffect)BuiltInRegistries.c.a(MinecraftKey.a((String)data));
    }

    public static void initNetworkManager(NetworkManager network) {
        SocketAddress socketAddress;
        network.m = new EmptyChannel(null);
        network.n = socketAddress = new SocketAddress(){
            private static final long serialVersionUID = 8207338859896320185L;
        };
    }

    public static boolean isLeashed(NPC npc, Supplier<Boolean> isLeashed, EntityInsentient entity) {
        return NMS.isLeashed(npc, isLeashed, () -> entity.a(true, false));
    }

    public static void minecartItemLogic(EntityMinecartAbstract minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        int offset = npc.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0));
        minecart.a(npc.data().has(NPC.Metadata.ITEM_ID));
        if (minecart.y()) {
            Material mat = npc.getItemProvider().get().getType();
            minecart.b(((Block)BuiltInRegistries.f.a(MinecraftKey.a((String)mat.getKey().toString()))).o());
        }
        minecart.l(offset);
    }

    public static boolean moveFish(NPC npc, EntityInsentient handle, Vec3D vec3d) {
        if (npc == null) {
            return false;
        }
        if (!npc.useMinecraftAI() && handle.aT() && !npc.getNavigator().isNavigating()) {
            handle.a(handle instanceof EntityDolphin || handle instanceof Axolotl ? handle.eW() : (handle instanceof EntityTurtle ? 0.1f : 0.01f), vec3d);
            handle.a(EnumMoveType.a, handle.dj());
            handle.f(handle.dj().a(0.9));
            return true;
        }
        return false;
    }

    public static void resetPuffTicks(EntityPufferFish fish) {
        try {
            PUFFERFISH_C.invoke(fish, 0);
            PUFFERFISH_D.invoke(fish, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void restoreGoals(NPC npc, PathfinderGoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                Set list = selector.b();
                list.clear();
                Collection old = (Collection)npc.data().get("selector" + i);
                if (old != null) {
                    list.addAll(old);
                }
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).b.a(packet);
    }

    public static void sendPackets(Player player, Iterable<Packet<?>> packets) {
        if (packets == null) {
            return;
        }
        for (Packet<?> packet : packets) {
            ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).b.a(packet);
        }
    }

    public static void setAttribute(EntityLiving entity, AttributeBase attribute, double value) {
        AttributeModifiable attr = entity.a(attribute);
        if (attr == null) {
            try {
                AttributeProvider provider = ATTRIBUTE_SUPPLIER.invoke(entity.eI());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(attribute, new AttributeModifiable(attribute, att -> {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            attr = entity.a(attribute);
        }
        attr.a(value);
    }

    public static void setBukkitEntity(net.minecraft.world.entity.Entity entity, CraftEntity bukkitEntity) {
        try {
            BUKKITENTITY_FIELD_SETTER.invoke(entity, bukkitEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFallingBlockState(EntityFallingBlock handle, IBlockData state) {
        try {
            FALLING_BLOCK_STATE_SETTER.invoke(handle, state);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLife(EntityFishingHook entity, int life) {
        try {
            FISHING_HOOK_LIFE.invoke(entity, life);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLookControl(EntityInsentient mob, ControllerLook control) {
        try {
            LOOK_CONTROL_SETTER.invoke(mob, control);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setNotInSchool(EntityFish entity) {
        try {
            if (ENTITY_FISH_NUM_IN_SCHOOL != null) {
                ENTITY_FISH_NUM_IN_SCHOOL.invoke(entity, 2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, boolean justCreated) {
        try {
            EntitySize entitysize = SIZE_FIELD_GETTER.invoke(entity);
            EntityPose entitypose = entity.al();
            EntitySize entitysize1 = entity.a(entitypose);
            SIZE_FIELD_SETTER.invoke(entity, entitysize1);
            HEAD_HEIGHT.invoke(entity, HEAD_HEIGHT_METHOD.invoke(entity, entitypose, entitysize1));
            if (entitysize1.a < entitysize.a) {
                // empty if block
            }
            AxisAlignedBB axisalignedbb = entity.cD();
            entity.a(new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c, axisalignedbb.a + (double)entitysize1.a, axisalignedbb.b + (double)entitysize1.b, axisalignedbb.c + (double)entitysize1.a));
            if (entitysize1.a > entitysize.a && !justCreated && !entity.H.B) {
                float f = entitysize.a - entitysize1.a;
                entity.a(EnumMoveType.a, new Vec3D((double)f, 0.0, (double)f));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, EntitySize size) {
        try {
            SIZE_FIELD_SETTER.invoke(entity, size);
            HEAD_HEIGHT.invoke(entity, HEAD_HEIGHT_METHOD.invoke(entity, entity.al(), entity.a(entity.al())));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static net.minecraft.world.entity.Entity teleportAcrossWorld(net.minecraft.world.entity.Entity entity, WorldServer worldserver, Position location) {
        if (FIND_DIMENSION_ENTRY_POINT == null || entity.dB()) {
            return null;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        ShapeDetectorShape sds = null;
        try {
            sds = location == null ? FIND_DIMENSION_ENTRY_POINT.invoke(entity, worldserver) : new ShapeDetectorShape(new Vec3D(location.a(), location.b(), location.c()), Vec3D.b, entity.dw(), entity.dy(), worldserver, (CraftPortalEvent)null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (npc == null || sds == null) {
            return null;
        }
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        npc.spawn(new Location((World)worldserver.getWorld(), sds.a.c, sds.a.d, sds.a.e, sds.c, sds.d));
        net.minecraft.world.entity.Entity handle = ((CraftEntity)npc.getEntity()).getHandle();
        handle.f(sds.b);
        handle.aY = entity.aY;
        try {
            PORTAL_ENTRANCE_POS_SETTER.invoke(handle, PORTAL_ENTRANCE_POS_GETTER.invoke(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return handle;
    }

    public static void updateAI(EntityLiving entity) {
        if (entity instanceof EntityInsentient) {
            EntityInsentient handle = (EntityInsentient)entity;
            handle.I().a();
            handle.G().c();
            handle.D().a();
            handle.C().a();
            handle.E().b();
        } else if (entity instanceof MobAI) {
            ((MobAI)entity).tickAI();
        }
    }

    public static void updateMinecraftAIState(NPC npc, EntityInsentient entity) {
        if (npc == null) {
            return;
        }
        if (npc.useMinecraftAI()) {
            NMSImpl.restoreGoals(npc, entity.bN, entity.bO);
            if (npc.data().has("behavior-map")) {
                TreeMap behavior = (TreeMap)npc.data().get("behavior-map");
                NMSImpl.getBehaviorMap((EntityLiving)entity).putAll(behavior);
                npc.data().remove("behavior-map");
            }
        } else {
            NMSImpl.clearGoals(npc, entity.bN, entity.bO);
            TreeMap<?, ?> behaviorMap = NMSImpl.getBehaviorMap((EntityLiving)entity);
            if (behaviorMap.size() > 0) {
                npc.data().set("behavior-map", new TreeMap((SortedMap<?, ?>)behaviorMap));
                behaviorMap.clear();
            }
        }
    }

    static {
        FALLING_BLOCK_STATE_SETTER = NMS.getFirstSetter(EntityFallingBlock.class, IBlockData.class);
        FIND_DIMENSION_ENTRY_POINT = NMS.getFirstMethodHandleWithReturnType(net.minecraft.world.entity.Entity.class, true, ShapeDetectorShape.class, WorldServer.class);
        FISHING_HOOK_LIFE = NMS.getSetter(EntityFishingHook.class, "i");
        FLYING_MOVECONTROL_FLOAT_GETTER = NMS.getFirstGetter(ControllerMoveFlying.class, Boolean.TYPE);
        FLYING_MOVECONTROL_FLOAT_SETTER = NMS.getFirstSetter(ControllerMoveFlying.class, Boolean.TYPE);
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        HEAD_HEIGHT = NMS.getSetter(net.minecraft.world.entity.Entity.class, "bf");
        HEAD_HEIGHT_METHOD = NMS.getFirstMethodHandle(net.minecraft.world.entity.Entity.class, true, EntityPose.class, EntitySize.class);
        INTERACTION_HEIGHT = (DataWatcherObject)NMS.getStaticObject(Interaction.class, "d");
        INTERACTION_WIDTH = (DataWatcherObject)NMS.getStaticObject(Interaction.class, "c");
        JUMP_FIELD = NMS.getGetter(EntityLiving.class, "bi");
        LOOK_CONTROL_SETTER = NMS.getFirstSetter(EntityInsentient.class, ControllerLook.class);
        MAKE_REQUEST = NMS.getMethodHandle(YggdrasilAuthenticationService.class, "makeRequest", true, URL.class, Object.class, Class.class);
        MOVE_CONTROLLER_OPERATION = NMS.getSetter(ControllerMove.class, "k");
        NAVIGATION_CREATE_PATHFINDER = NMS.getFirstMethodHandleWithReturnType(NavigationAbstract.class, true, Pathfinder.class, Integer.TYPE);
        NAVIGATION_PATH = NMS.getFirstGetter(NavigationAbstract.class, PathEntity.class);
        NAVIGATION_PATHFINDER = NMS.getFirstFinalSetter(NavigationAbstract.class, Pathfinder.class);
        NAVIGATION_WORLD_FIELD = NMS.getFirstSetter(NavigationAbstract.class, net.minecraft.world.level.World.class);
        PAPER_PLAYER_MOB_COUNTS = NMS.getGetter(EntityPlayer.class, "mobCounts", false);
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_GETTER = NMS.getFirstGetter(PlayerChunkMap.class, Integer.TYPE);
        PLAYER_CHUNK_MAP_VIEW_DISTANCE_SETTER = NMS.getFirstSetter(PlayerChunkMap.class, Integer.TYPE);
        PLAYERINFO_ENTRIES = PLAYER_INFO_ENTRIES_LIST = NMS.getFirstFinalSetter(ClientboundPlayerInfoUpdatePacket.class, List.class);
        PORTAL_ENTRANCE_POS_GETTER = NMS.getGetter(net.minecraft.world.entity.Entity.class, "aw");
        PORTAL_ENTRANCE_POS_SETTER = NMS.getSetter(net.minecraft.world.entity.Entity.class, "aw");
        POSITION_CODEC_GETTER = NMS.getFirstGetter(EntityTrackerEntry.class, VecDeltaCodec.class);
        PUFFERFISH_C = NMS.getSetter(EntityPufferFish.class, "bS");
        PUFFERFISH_D = NMS.getSetter(EntityPufferFish.class, "bT");
        RABBIT_TYPE_DATAWATCHER = (DataWatcherObject)NMS.getFirstStaticObject(EntityRabbit.class, DataWatcherObject.class);
        RANDOM = Util.getFastRandom();
        SERVER_ENTITY_GETTER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
        SIZE_FIELD_GETTER = NMS.getFirstGetter(net.minecraft.world.entity.Entity.class, EntitySize.class);
        SIZE_FIELD_SETTER = NMS.getFirstSetter(net.minecraft.world.entity.Entity.class, EntitySize.class);
        try {
            ENTITY_REGISTRY = new CustomEntityRegistry(BuiltInRegistries.h);
            ENTITY_REGISTRY_SETTER = NMS.getFinalSetter(BuiltInRegistries.class, "h");
            ENTITY_REGISTRY_SETTER.invoke(ENTITY_REGISTRY);
        }
        catch (Throwable e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
            e.printStackTrace();
        }
    }

    private static class MCTargetNavigator
    implements MCTargetStrategy.TargetNavigator {
        private final Entity entity;
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private MCTargetNavigator(Entity entity, NavigationAbstract navigation, Entity target, NavigatorParameters parameters) {
            this.entity = entity;
            this.navigation = navigation;
            this.target = target;
            this.parameters = parameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = this.parameters.entityTargetLocationMapper().apply(this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speedModifier());
        }

        @Override
        public void stop() {
            this.navigation.n();
        }

        @Override
        public void update() {
            this.navigation.c();
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract nav) {
            this.navigation = nav;
        }

        @Override
        public Iterator<Vector> iterator() {
            final PathEntity path = NMSImpl.getPathEntity(this.navigation);
            final int npoints = path == null ? 0 : path.e();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = npoints > 0 ? path.a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint old = this.curr;
                    this.curr = this.i + 1 < npoints ? path.a(++this.i) : null;
                    return new Vector(old.a, old.b, old.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, IInventory inventory, IInventory resultInventory, ContainerAnvil container, Inventory wrapped) {
            super(location, inventory, resultInventory, container);
            this.wrapped = wrapped;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int slot, ItemStack item) {
            super.setItem(slot, item);
            this.wrapped.setItem(slot, item);
        }
    }
}

