/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.io.CharStreams;
import com.mojang.authlib.GameProfile;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.SkinProperty;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MojangSkinGenerator {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    public static JSONObject generateFromPNG(byte[] png, boolean slim) throws InterruptedException, ExecutionException {
        return EXECUTOR.submit(() -> {
            FilterOutputStream out = null;
            InputStreamReader reader = null;
            URL target = new URI("https://api.mineskin.org/generate/upload" + (slim ? "?model=slim" : "")).toURL();
            HttpURLConnection con = (HttpURLConnection)target.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", "Citizens/2.0");
            con.setRequestProperty("Cache-Control", "no-cache");
            con.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            con.setConnectTimeout(2000);
            con.setReadTimeout(30000);
            out = new DataOutputStream(con.getOutputStream());
            ((DataOutputStream)out).writeBytes("--*****\r\n");
            ((DataOutputStream)out).writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"skin.png\"\r\n");
            ((DataOutputStream)out).writeBytes("Content-Type: image/png\r\n\r\n");
            out.write(png);
            ((DataOutputStream)out).writeBytes("\r\n");
            ((DataOutputStream)out).writeBytes("--*****\r\n");
            ((DataOutputStream)out).writeBytes("Content-Disposition: form-data; name=\"name\";\r\n\r\n\r\n");
            if (slim) {
                ((DataOutputStream)out).writeBytes("--*****\r\n");
                ((DataOutputStream)out).writeBytes("Content-Disposition: form-data; name=\"variant\";\r\n\r\n");
                ((DataOutputStream)out).writeBytes("slim\r\n");
            }
            ((DataOutputStream)out).writeBytes("--*****--\r\n");
            ((DataOutputStream)out).flush();
            out.close();
            reader = new InputStreamReader(con.getInputStream());
            String str = CharStreams.toString((Readable)reader);
            if (Messaging.isDebugging()) {
                Messaging.debug(str);
            }
            if (con.getResponseCode() != 200) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject output = (JSONObject)new JSONParser().parse(str);
            JSONObject data = (JSONObject)output.get((Object)"data");
            con.disconnect();
            JSONObject jSONObject = data;
            return jSONObject;
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }

    public static JSONObject generateFromURL(String url, boolean slim) throws InterruptedException, ExecutionException {
        return EXECUTOR.submit(() -> {
            FilterOutputStream out = null;
            InputStreamReader reader = null;
            URL target = new URI("https://api.mineskin.org/generate/url").toURL();
            HttpURLConnection con = (HttpURLConnection)target.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", "Citizens/2.0");
            con.setRequestProperty("Cache-Control", "no-cache");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Content-Type", "application/json");
            con.setConnectTimeout(2000);
            con.setReadTimeout(30000);
            out = new DataOutputStream(con.getOutputStream());
            JSONObject req = new JSONObject();
            req.put((Object)"url", (Object)url);
            req.put((Object)"name", (Object)"");
            if (slim) {
                req.put((Object)"variant", (Object)"slim");
            }
            ((DataOutputStream)out).writeBytes(req.toJSONString().replace("\\", ""));
            out.close();
            reader = new InputStreamReader(con.getInputStream());
            String str = CharStreams.toString((Readable)reader);
            if (Messaging.isDebugging()) {
                Messaging.debug(str);
            }
            if (con.getResponseCode() != 200) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject output = (JSONObject)new JSONParser().parse(str);
            JSONObject data = (JSONObject)output.get((Object)"data");
            con.disconnect();
            JSONObject jSONObject = data;
            return jSONObject;
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }

    public static GameProfile getFilledGameProfileByXUID(String name, long xuid) throws InterruptedException, ExecutionException {
        return EXECUTOR.submit(() -> {
            InputStreamReader reader = null;
            URL target = new URI("https://api.geysermc.org/v2/skin/" + xuid).toURL();
            HttpURLConnection con = (HttpURLConnection)target.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Citizens/2.0");
            con.setRequestProperty("Accept", "application/json");
            con.setConnectTimeout(2000);
            con.setReadTimeout(20000);
            reader = new InputStreamReader(con.getInputStream());
            String str = CharStreams.toString((Readable)reader);
            if (Messaging.isDebugging()) {
                Messaging.debug(str);
            }
            if (con.getResponseCode() != 200) {
                GameProfile gameProfile = null;
                return gameProfile;
            }
            JSONObject output = (JSONObject)new JSONParser().parse(str);
            con.disconnect();
            String hex = Long.toHexString(xuid);
            GameProfile profile = new GameProfile(UUID.fromString("00000000-0000-0000-" + hex.substring(0, 4) + "-" + hex.substring(4)), name);
            new SkinProperty((String)output.get((Object)"texture_id"), (String)output.get((Object)"value"), (String)output.get((Object)"signature")).apply(profile);
            GameProfile gameProfile = profile;
            return gameProfile;
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }

    public static Long getXUIDFromName(String name) throws InterruptedException, ExecutionException {
        return EXECUTOR.submit(() -> {
            InputStreamReader reader = null;
            try {
                URL target = new URI("https://api.geysermc.org/v2/xbox/xuid/" + name).toURL();
                HttpURLConnection con = (HttpURLConnection)target.openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("User-Agent", "Citizens/2.0");
                con.setRequestProperty("Accept", "application/json");
                con.setConnectTimeout(2000);
                con.setReadTimeout(10000);
                reader = new InputStreamReader(con.getInputStream());
                String str = CharStreams.toString((Readable)reader);
                if (Messaging.isDebugging()) {
                    Messaging.debug(str);
                }
                if (con.getResponseCode() != 200) {
                    Long l = null;
                    return l;
                }
                JSONObject output = (JSONObject)new JSONParser().parse(str);
                con.disconnect();
                if (!output.containsKey((Object)"xuid")) {
                    Long l = null;
                    return l;
                }
                Long l = ((Number)output.get((Object)"xuid")).longValue();
                return l;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }
}

