/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class StatusMapper
extends BehaviorGoalAdapter {
    private final Supplier<BehaviorStatus> to;
    private final Behavior wrapping;

    private StatusMapper(Behavior wrapping, Supplier<BehaviorStatus> to) {
        this.wrapping = wrapping;
        this.to = to;
    }

    @Override
    public void reset() {
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        return this.to.get();
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static StatusMapper mapping(Behavior wrapping, Supplier<BehaviorStatus> to) {
        return new StatusMapper(wrapping, to);
    }

    public static Behavior singleUse(final Behavior base) {
        return new Behavior(){

            @Override
            public void reset() {
                base.reset();
            }

            @Override
            public BehaviorStatus run() {
                BehaviorStatus status = base.run();
                switch (status) {
                    case FAILURE: 
                    case SUCCESS: {
                        return BehaviorStatus.RESET_AND_REMOVE;
                    }
                }
                return status;
            }

            @Override
            public boolean shouldExecute() {
                return base.shouldExecute();
            }
        };
    }
}

