/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;

public class GameProfileWrapper {
    public final String name;
    public Multimap<String, SkinProperty> properties;
    public final UUID uuid;
    private static Constructor<GameProfile> GAME_PROFILE_CONSTRUCTOR;
    private static Constructor<GameProfile> GAME_PROFILE_RECORD_CONSTRUCTOR;
    private static MethodHandle GET_ID_METHOD;
    private static MethodHandle GET_NAME_METHOD;
    private static MethodHandle PROPERTIES_METHOD;
    private static Constructor<?> PROPERTY_CONSTRUCTOR;

    public GameProfileWrapper(String name, UUID uuid, Multimap<String, SkinProperty> properties) {
        this.name = name;
        this.uuid = uuid;
        this.properties = properties;
    }

    public GameProfile applyProperties(Object profile) {
        try {
            HashMultimap mojang = HashMultimap.create();
            for (String key : this.properties.keySet()) {
                mojang.putAll((Object)key, (Iterable)Collections2.transform((Collection)this.properties.get((Object)key), p -> {
                    try {
                        return PROPERTY_CONSTRUCTOR.newInstance(p.name, p.value, p.signature);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }));
            }
            if (GAME_PROFILE_RECORD_CONSTRUCTOR != null) {
                return GAME_PROFILE_RECORD_CONSTRUCTOR.newInstance(GameProfileWrapper.getId(profile), GameProfileWrapper.getName(profile), new PropertyMap((Multimap)mojang));
            }
            if (GAME_PROFILE_CONSTRUCTOR != null) {
                GameProfile object = GAME_PROFILE_CONSTRUCTOR.newInstance(GameProfileWrapper.getId(profile), GameProfileWrapper.getName(profile));
                GameProfileWrapper.setProperties(object, (Multimap)mojang);
                return object;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GameProfileWrapper fromMojangProfile(Object profile) {
        if (profile == null) {
            return null;
        }
        return new GameProfileWrapper(GameProfileWrapper.getName(profile), GameProfileWrapper.getId(profile), GameProfileWrapper.getProperties(profile));
    }

    private static UUID getId(Object profile) {
        try {
            return GET_ID_METHOD.invoke(profile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getName(Object profile) {
        try {
            return GET_NAME_METHOD.invoke(profile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Multimap<String, SkinProperty> getProperties(Object profile) {
        try {
            Multimap mojang = PROPERTIES_METHOD.invoke(profile);
            HashMultimap converted = HashMultimap.create();
            for (String key : mojang.keySet()) {
                converted.putAll((Object)key, (Iterable)mojang.get((Object)key).stream().map(o -> SkinProperty.fromMojang(o)).collect(Collectors.toList()));
            }
            return converted;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setProperties(Object profile, Multimap map) {
        try {
            Multimap mojang = PROPERTIES_METHOD.invoke(profile);
            mojang.clear();
            mojang.putAll(map);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        GET_ID_METHOD = null;
        GET_NAME_METHOD = null;
        PROPERTIES_METHOD = null;
        try {
            PROPERTY_CONSTRUCTOR = Class.forName("com.mojang.authlib.properties.Property").getConstructor(String.class, String.class, String.class);
            PROPERTY_CONSTRUCTOR.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            GAME_PROFILE_RECORD_CONSTRUCTOR = GameProfile.class.getConstructor(UUID.class, String.class, PropertyMap.class);
            GAME_PROFILE_RECORD_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            try {
                GAME_PROFILE_CONSTRUCTOR = GameProfile.class.getConstructor(UUID.class, String.class);
                GAME_PROFILE_CONSTRUCTOR.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e1) {
                e1.printStackTrace();
            }
        }
        PROPERTIES_METHOD = NMS.getMethodHandle(GameProfile.class, "getProperties", false, new Class[0]);
        if (PROPERTIES_METHOD == null) {
            PROPERTIES_METHOD = NMS.getMethodHandle(GameProfile.class, "properties", false, new Class[0]);
        }
        if ((GET_NAME_METHOD = NMS.getMethodHandle(GameProfile.class, "getName", false, new Class[0])) == null) {
            GET_NAME_METHOD = NMS.getMethodHandle(GameProfile.class, "name", false, new Class[0]);
        }
        if ((GET_ID_METHOD = NMS.getMethodHandle(GameProfile.class, "getId", false, new Class[0])) == null) {
            GET_ID_METHOD = NMS.getMethodHandle(GameProfile.class, "id", false, new Class[0]);
        }
    }
}

