/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.persistence.LocationPersister;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;

@TraitName(value="location")
public class CurrentLocation
extends Trait {
    @Persist
    private float bodyYaw = Float.NaN;
    @Persist(value="", required=true)
    private Location location = new Location(null, 0.0, 0.0, 0.0);

    public CurrentLocation() {
        super("location");
    }

    public float getBodyYaw() {
        return this.bodyYaw;
    }

    public ChunkCoord getChunkCoord() {
        return new ChunkCoord(this.getWorldUUID(), this.location.getBlockX() >> 4, this.location.getBlockZ() >> 4);
    }

    public Location getLocation() {
        return this.location.getWorld() == null ? null : this.location.clone();
    }

    public UUID getWorldUUID() {
        if (this.location.getWorld() == null) {
            if (this.location instanceof LocationPersister.LazilyLoadedLocation) {
                return ((LocationPersister.LazilyLoadedLocation)this.location).getWorldUUID();
            }
            return null;
        }
        return this.location.getWorld().getUID();
    }

    @Override
    public void load(DataKey key) {
        key.removeKey("headYaw");
    }

    @Override
    public void onSpawn() {
        if (!Float.isNaN(this.bodyYaw)) {
            NMS.setBodyYaw(this.npc.getEntity(), this.bodyYaw);
        }
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        this.location = this.npc.getEntity().getLocation(this.location);
        this.bodyYaw = NMS.getYaw(this.npc.getEntity());
    }

    public void setLocation(Location loc) {
        this.location = loc.clone();
    }

    public String toString() {
        return "CurrentLocation{" + this.location + "}";
    }
}

