/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.ai.goals.MoveToGoal;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

public class FollowPathGoal
extends BehaviorGoalAdapter {
    private int idx;
    private final NPC npc;
    private final List<MoveToGoal> path;

    public FollowPathGoal(NPC npc, List<MoveToGoal> path) {
        this.npc = npc;
        this.path = path;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.idx = 0;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus status;
        if (this.idx >= this.path.size()) {
            return BehaviorStatus.SUCCESS;
        }
        if (!this.npc.getNavigator().isNavigating()) {
            this.setPath();
        }
        if ((status = this.path.get(this.idx).run()) == BehaviorStatus.SUCCESS) {
            ++this.idx;
            this.setPath();
            return BehaviorStatus.RUNNING;
        }
        return status;
    }

    private void setPath() {
        if (this.idx >= this.path.size()) {
            return;
        }
        this.path.get(this.idx).shouldExecute();
    }

    @Override
    public boolean shouldExecute() {
        return !this.npc.getNavigator().isNavigating() && this.path != null;
    }

    public static FollowPathGoal create(NPC npc, List<MoveToGoal> path) {
        return new FollowPathGoal(npc, path);
    }

    public static FollowPathGoal createFromLocations(NPC npc, List<Location> path) {
        return new FollowPathGoal(npc, path.stream().map(loc -> new MoveToGoal(npc, (Location)loc)).collect(Collectors.toList()));
    }
}

