/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportTrigger
implements WaypointTrigger {
    @Persist(required=true)
    private Location location;

    public TeleportTrigger() {
    }

    public TeleportTrigger(Location location) {
        this.location = location;
    }

    @Override
    public String description() {
        return String.format("[[Teleport]] to [%s, %d, %d, %d]", this.location.getWorld().getName(), this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    @Override
    public void onWaypointReached(NPC npc, Location waypoint) {
        if (this.location != null) {
            npc.teleport(this.location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }
}

