/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;

@TraitName(value="targetable")
public class TargetableTrait
extends Trait {
    @Persist
    private Boolean targetable;
    private Set<UUID> targeters;
    private static boolean SUPPORTS_GET_ENTITY = true;

    public TargetableTrait() {
        super("targetable");
    }

    public void addTargeter(UUID uuid) {
        if (this.targeters == null) {
            this.targeters = new HashSet<UUID>();
        }
        this.targeters.add(uuid);
    }

    public void clearTargeters() {
        if (this.targeters == null) {
            return;
        }
        if (SUPPORTS_GET_ENTITY) {
            for (UUID entityUUID : this.targeters) {
                Entity entity = Bukkit.getEntity((UUID)entityUUID);
                if (!(entity instanceof Mob) || !entity.isValid()) continue;
                ((Mob)entity).setTarget(null);
            }
        }
        this.targeters = null;
    }

    public boolean isTargetable() {
        return this.targetable == null ? !this.npc.isProtected() : this.targetable;
    }

    @Override
    public void onDespawn() {
        this.clearTargeters();
    }

    public void removeTargeter(UUID uuid) {
        if (this.targeters != null) {
            this.targeters.remove(uuid);
        }
    }

    public void setTargetable(boolean targetable) {
        if (Boolean.valueOf(targetable).equals(this.targetable)) {
            return;
        }
        this.targetable = targetable;
        if (!targetable) {
            this.clearTargeters();
        }
    }

    static {
        try {
            Bukkit.class.getMethod("getEntity", UUID.class);
        }
        catch (NoSuchMethodException e) {
            SUPPORTS_GET_ENTITY = false;
        }
    }
}

