/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import java.util.Arrays;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CitizensInventoryClickEvent
extends InventoryClickEvent {
    private final InventoryClickEvent event;
    private final ItemStack result;

    public CitizensInventoryClickEvent(InventoryClickEvent event, int pickupAmount) {
        super(event.getView(), event.getSlotType(), event.getSlot(), event.getClick(), event.getAction(), event.getHotbarButton());
        this.event = event;
        this.result = this.getResult(event, pickupAmount);
    }

    public ItemStack getCurrentItem() {
        return this.event.getCurrentItem() == null || this.event.getCurrentItem().getType() == Material.AIR ? null : this.event.getCurrentItem();
    }

    public ItemStack getCurrentItemNonNull() {
        return this.event.getCurrentItem() == null ? new ItemStack(Material.AIR, 0) : this.event.getCurrentItem();
    }

    public ItemStack getCursor() {
        return this.event.getCursor() == null || this.event.getCursor().getType() == Material.AIR ? null : this.event.getCursor();
    }

    public ItemStack getCursorNonNull() {
        return this.event.getCursor() == null ? new ItemStack(Material.AIR, 0) : this.event.getCursor();
    }

    public Event.Result getResult() {
        return this.event.getResult();
    }

    private ItemStack getResult(InventoryClickEvent event, int pickupAmount) {
        ItemStack stack = event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR ? event.getCursor().clone() : event.getCurrentItem().clone();
        int formerAmount = event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR ? 0 : event.getCurrentItem().getAmount();
        switch (event.getAction()) {
            case PICKUP_ONE: {
                stack.setAmount(formerAmount - 1);
                break;
            }
            case PICKUP_SOME: {
                stack.setAmount(formerAmount - pickupAmount);
                break;
            }
            case PICKUP_HALF: {
                stack.setAmount((int)Math.floor((double)formerAmount / 2.0));
                break;
            }
            case PICKUP_ALL: {
                stack = null;
                break;
            }
            case PLACE_ALL: 
            case PLACE_SOME: {
                stack.setAmount(Math.min(formerAmount + event.getCursor().getAmount(), stack.getType().getMaxStackSize()));
                break;
            }
            case PLACE_ONE: {
                stack.setAmount(Math.min(formerAmount + 1, stack.getType().getMaxStackSize()));
                break;
            }
            default: {
                event.setCancelled(true);
                return null;
            }
        }
        return stack;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public ItemStack getResultItemNonNull() {
        return this.result == null ? new ItemStack(Material.AIR, 0) : this.result;
    }

    public boolean isCancelled() {
        return this.event.isCancelled();
    }

    public void setCancelled(boolean cancel) {
        this.event.setCancelled(cancel);
    }

    public void setCurrentItem(ItemStack item) {
        this.event.setCurrentItem(item);
    }

    public void setCurrentItemDescription(String description) {
        ItemMeta meta = this.getCurrentItem().getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.setLore(Arrays.asList(Messaging.parseComponents(description).split("\n")));
        this.event.getCurrentItem().setItemMeta(meta);
    }

    public void setCursor(ItemStack cursor) {
        this.event.setCursor(cursor);
    }

    public void setResult(Event.Result result) {
        this.event.setResult(result);
    }
}

