/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.OldEnumCompat;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

@TraitName(value="profession")
public class VillagerProfession
extends Trait {
    private Villager.Profession profession = Villager.Profession.FARMER;
    private static boolean SUPPORT_ZOMBIE_VILLAGER = false;

    public VillagerProfession() {
        super("profession");
    }

    public Villager.Profession getProfession() {
        return this.profession;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        try {
            OldEnumCompat.VillagerProfessionEnum vpe = OldEnumCompat.VillagerProfessionEnum.valueOf(key.getString(""));
            this.profession = (Villager.Profession)vpe.getInstance();
            if ("NORMAL".equals(vpe.name())) {
                this.profession = Villager.Profession.FARMER;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new NPCLoadException("Invalid profession.");
        }
    }

    @Override
    public void onSpawn() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).setProfession(this.profession);
            return;
        }
        if (SUPPORT_ZOMBIE_VILLAGER && this.npc.getEntity() instanceof ZombieVillager) {
            ((ZombieVillager)this.npc.getEntity()).setVillagerProfession(this.profession);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setString("", new OldEnumCompat.VillagerProfessionEnum(this.profession).name());
    }

    public void setProfession(Villager.Profession profession) {
        if ("NORMAL".equals(new OldEnumCompat.VillagerProfessionEnum(profession).name())) {
            profession = Villager.Profession.FARMER;
        }
        this.profession = profession;
        this.onSpawn();
    }

    public String toString() {
        return "Profession{" + this.profession + "}";
    }

    static {
        try {
            Class.forName("org.bukkit.entity.ZombieVillager").getMethod("setVillagerProfession", Villager.Profession.class);
            SUPPORT_ZOMBIE_VILLAGER = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

