/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private String name;
    private final ConfigurationSection section;

    public MemoryDataKey() {
        super("");
        this.section = new MemoryConfiguration();
    }

    MemoryDataKey(ConfigurationSection root, String path) {
        super(path);
        this.section = root;
    }

    @Override
    public MemoryDataKey copy() {
        MemoryConfiguration section = new MemoryConfiguration();
        for (Map.Entry<String, Object> entry : this.getValuesDeep().entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createSection(entry.getKey().toString(), (Map)entry.getValue());
                continue;
            }
            section.set(entry.getKey().toString(), entry.getValue());
        }
        return new MemoryDataKey((ConfigurationSection)section, "");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataKey other = (MemoryDataKey)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public boolean getBoolean(String key) {
        String path = this.createRelativeKey(key);
        if (this.valueExists(path)) {
            if (this.section.getString(path) == null) {
                return this.section.getBoolean(path);
            }
            return Boolean.parseBoolean(this.section.getString(path));
        }
        return false;
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return (Boolean)this.section.get(this.createRelativeKey(key), (Object)def);
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double def) {
        String path = this.createRelativeKey(key);
        if (this.valueExists(path)) {
            Object value = this.section.get(path);
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            String raw = value.toString();
            if (raw.isEmpty()) {
                return def;
            }
            return Double.parseDouble(raw);
        }
        return def;
    }

    @Override
    public DataKey getFromRoot(String path) {
        return new MemoryDataKey((ConfigurationSection)this.section.getRoot(), path);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int def) {
        String path = this.createRelativeKey(key);
        if (this.valueExists(path)) {
            Object value = this.section.get(path);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String raw = value.toString();
            if (raw.isEmpty()) {
                return def;
            }
            return Integer.parseInt(raw);
        }
        return def;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long def) {
        String path = this.createRelativeKey(key);
        if (this.valueExists(path)) {
            Object value = this.section.get(path);
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            String raw = value.toString();
            if (raw.isEmpty()) {
                return def;
            }
            return Long.parseLong(raw);
        }
        return def;
    }

    @Override
    public Object getRaw(String key) {
        return this.section.get(this.createRelativeKey(key));
    }

    @Override
    public MemoryDataKey getRelative(String relative) {
        if (relative == null || relative.isEmpty()) {
            return this;
        }
        return new MemoryDataKey(this.section, this.createRelativeKey(relative));
    }

    public ConfigurationSection getSection(String key) {
        return this.section.getConfigurationSection(this.createRelativeKey(key));
    }

    @Override
    public String getString(String key) {
        Object val = this.section.get(key = this.createRelativeKey(key));
        if (val != null && !(val instanceof ConfigurationSection)) {
            return val.toString();
        }
        return "";
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        ConfigurationSection head = this.section.getConfigurationSection(this.path);
        if (head == null) {
            return Collections.emptyList();
        }
        Set keys = head.getKeys(false);
        return Iterables.transform((Iterable)keys, k -> new MemoryDataKey(this.section, this.createRelativeKey((String)k)));
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        return this.sectionToValues(this.section.getConfigurationSection(this.path));
    }

    @Override
    public int hashCode() {
        return 31 + (this.path == null ? 0 : this.path.hashCode());
    }

    @Override
    public boolean keyExists(String key) {
        return this.section.get(this.createRelativeKey(key)) != null;
    }

    @Override
    public String name() {
        if (this.name == null) {
            int idx = this.path.lastIndexOf(46);
            this.name = idx == -1 ? this.path : this.path.substring(idx + 1);
        }
        return this.name;
    }

    @Override
    public void removeKey(String key) {
        this.set(key, null);
    }

    private void set(String key, Object value) {
        this.section.set(this.createRelativeKey(key), value);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.set(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.set(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.set(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.set(key, value);
    }

    @Override
    public void setRaw(String key, Object value) {
        this.set(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.set(key, value);
    }

    public String toString() {
        return "MemoryDataKey[" + this.path + "]";
    }

    private boolean valueExists(String key) {
        Object object = this.section.get(key);
        return object != null && !(object instanceof ConfigurationSection);
    }
}

