/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class DelayTrigger
implements WaypointTrigger {
    @Persist
    private int delay = 0;

    public DelayTrigger() {
    }

    public DelayTrigger(int delay) {
        this.delay = delay;
    }

    private void delay(WaypointProvider provider) {
        provider.setPaused(true);
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> provider.setPaused(false), (long)this.delay);
    }

    @Override
    public String description() {
        return String.format("[[Delay]] for [[%d]] ticks", this.delay);
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public void onWaypointReached(NPC npc, Location waypoint) {
        if (this.delay > 0) {
            this.delay(npc.getOrAddTrait(Waypoints.class).getCurrentProvider());
        }
    }
}

