/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Requirements(ownership=true, selected=true)
public class WaypointCommands {
    @Command(aliases={"waypoints", "wp"}, usage="add [x] [y] [z] (world) (--index idx)", desc="", modifiers={"add"}, min=4, max=5, permission="citizens.waypoints.add")
    public void add(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"index"}) Integer index) throws CommandException {
        World world;
        WaypointProvider provider = npc.getOrAddTrait(Waypoints.class).getCurrentProvider();
        if (!(provider instanceof LinearWaypointProvider)) {
            throw new CommandException();
        }
        List waypoints = (List)((LinearWaypointProvider)provider).waypoints();
        World world2 = world = args.argsLength() > 4 ? Bukkit.getWorld((String)args.getString(4)) : npc.getStoredLocation().getWorld();
        if (world == null) {
            throw new CommandException("citizens.commands.errors.missing-world");
        }
        Location loc = new Location(world, (double)args.getInteger(1), (double)args.getInteger(2), (double)args.getInteger(3));
        if (index == null) {
            index = waypoints.size();
        }
        if (index > waypoints.size() || index < 0) {
            throw new CommandException("Index out of range. Can't be more than " + waypoints.size());
        }
        waypoints.add(index, new Waypoint(loc));
        Messaging.sendTr(sender, "citizens.commands.waypoints.add.waypoint-added", Util.prettyPrintLocation(loc), index);
    }

    @Command(aliases={"waypoints", "wp"}, usage="disableteleport", desc="", modifiers={"disableteleport", "dt"}, min=1, max=1, permission="citizens.waypoints.disableteleport")
    public void disableTeleporting(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        npc.data().setPersistent(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, (Object)(npc.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))) == false ? 1 : 0));
        if (npc.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))).booleanValue()) {
            npc.getNavigator().getDefaultParameters().stuckAction(null);
            Messaging.sendTr(sender, "citizens.commands.waypoints.disableteleporting.disabled", npc.getName());
        } else {
            npc.getNavigator().getDefaultParameters().stuckAction(TeleportStuckAction.INSTANCE);
            Messaging.sendTr(sender, "citizens.commands.waypoints.disableteleporting.enabled", npc.getName());
        }
    }

    @Command(aliases={"waypoints", "wp"}, usage="hpa", desc="", modifiers={"hpa"}, min=1, max=1, permission="citizens.waypoints.hpa")
    public void hpa(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (Messaging.isDebugging() && sender.isOp()) {
            HPAGraph graph = new HPAGraph(new ChunkBlockSource(npc.getStoredLocation(), 16.0f), npc.getStoredLocation().getBlockX(), npc.getStoredLocation().getBlockY(), npc.getStoredLocation().getBlockZ());
            graph.addClusters(npc.getStoredLocation().getBlockX(), npc.getStoredLocation().getBlockZ());
            System.out.println(graph.findPath(new Location(npc.getStoredLocation().getWorld(), 8.0, 68.0, -134.0), new Location(npc.getStoredLocation().getWorld(), 11.0, 68.0, -131.0)));
        }
    }

    @Command(aliases={"waypoints", "wp"}, usage="provider [provider name]", desc="", modifiers={"provider"}, min=1, max=2, permission="citizens.waypoints.provider")
    public void provider(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean success;
        Waypoints waypoints = npc.getOrAddTrait(Waypoints.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.waypoints.current-provider", waypoints.getCurrentProviderName());
            waypoints.describeProviders(sender);
            return;
        }
        if (sender instanceof Player && Editor.hasEditor((Player)sender)) {
            Editor.leave((Player)sender);
        }
        if (!(success = waypoints.setWaypointProvider(args.getString(1)))) {
            throw new CommandException("Provider not found.");
        }
        Messaging.sendTr(sender, "citizens.commands.waypoints.set-provider", args.getString(1));
    }

    @Command(aliases={"waypoints", "wp"}, usage="remove (x y z world) (--index idx)", desc="", modifiers={"remove"}, min=1, max=5, permission="citizens.waypoints.remove")
    public void remove(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"index"}) Integer index) throws CommandException {
        WaypointProvider provider = npc.getOrAddTrait(Waypoints.class).getCurrentProvider();
        if (!(provider instanceof LinearWaypointProvider)) {
            throw new CommandException();
        }
        List waypoints = (List)((LinearWaypointProvider)provider).waypoints();
        if (index != null && index >= 0 && index < waypoints.size()) {
            waypoints.remove(index);
            Messaging.sendTr(sender, "citizens.commands.waypoints.waypoint-removed", index);
        } else {
            World world;
            if (args.argsLength() < 4) {
                throw new CommandUsageException();
            }
            World world2 = world = args.argsLength() > 4 ? Bukkit.getWorld((String)args.getString(4)) : npc.getStoredLocation().getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            Location loc = new Location(world, (double)args.getInteger(1), (double)args.getInteger(2), (double)args.getInteger(3));
            Iterator iterator = waypoints.iterator();
            while (iterator.hasNext()) {
                Waypoint wp = (Waypoint)iterator.next();
                if (!wp.getLocation().equals((Object)loc)) continue;
                iterator.remove();
            }
            Messaging.sendTr(sender, "citizens.commands.waypoints.waypoint-removed", Util.prettyPrintLocation(loc));
        }
    }
}

