package net.citizensnpcs.npc.ai;

import java.util.Map;

import org.bukkit.util.Vector;

import com.google.common.collect.Maps;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;

public class FallingExaminer implements BlockExaminer {
    private final Map<PathPoint, Integer> fall = Maps.newHashMap();
    private final int maxFallDistance;
    private final MinecraftBlockExaminer mc = new MinecraftBlockExaminer();

    public FallingExaminer(int maxFallDistance) {
        this.maxFallDistance = maxFallDistance;
    }

    @Override
    public StandableState canStandAt(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        if (!source.isYWithinBounds(pos.getBlockY() - 1))
            return StandableState.IGNORE;

        if (fall.containsKey(point))
            return StandableState.STANDABLE;

        Vector ppos = point.getParentPoint().getVector();
        if (!MinecraftBlockExaminer.canStandOn(
                source.getMaterialAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ()),
                source.getBlockDataAt(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()))) {
            Integer dist = fall.get(point.getParentPoint());
            if (dist == null && mc.isPassable(source, point.getParentPoint()) == PassableState.PASSABLE) {
                // start a fall
                fall.put(point, 0);
                return StandableState.STANDABLE;
            } else if (dist != null && dist < maxFallDistance && pos.getBlockY() < ppos.getBlockY()
                    && pos.getBlockX() == ppos.getBlockX() && pos.getBlockZ() == ppos.getBlockZ()
                    && MinecraftBlockExaminer.canStandIn(source.getMaterialAt(pos), source.getBlockDataAt(ppos))) {
                fall.put(point, dist + 1);
                return StandableState.STANDABLE;
            }
        }
        return StandableState.IGNORE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return fall.containsKey(point) ? 0.25f : 0;
    }

    @Override
    public PassableState isPassable(BlockSource source, PathPoint point) {
        return fall.containsKey(point) ? PassableState.PASSABLE : PassableState.IGNORE;
    }
}
