/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyConnection;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_20_R4.util.MobAI;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends arg
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private aln advancements;
    private MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(arh.class, (boolean)true, (Class[])new Class[]{dbx.class, dbx.class});

    public EntityHumanNPC(MinecraftServer minecraftServer, arf world, GameProfile gameProfile, aqu ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((btr)this);
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            try {
                GAMEMODE_SETTING.invoke(this.e, dbx.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.skinTracker = null;
        }
    }

    public void applyTexture(SkinProperty property) {
        this.gameProfile().getProperties().clear();
        this.gameProfile().getProperties().putAll((Object)property.name, (Iterable)ImmutableList.of((Object)new Property(property.name, property.value, property.signature)));
    }

    public boolean a(arg player) {
        return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
    }

    public boolean a(float f, float f1, brp damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, dse iblockdata, iz blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(brp damagesource) {
        if (this.be) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((arf)this.dP()).a((arg)this, bsw.c.a);
            ((arf)this.dP()).l().a((bsw)this);
        }, 15L);
    }

    public void m() {
        boolean navigating;
        if (this.npc == null) {
            super.m();
            return;
        }
        NMSImpl.callNPCMoveEvent(this);
        super.au();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity() || !Util.isLoaded((Location)this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe((double)this.dw(), (World)this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(evt.b);
        }
        evt mot = this.ds();
        if (Math.abs(mot.c) < (double)0.003f && Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f) {
            this.h(evt.b);
        }
        if (navigating) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aF();
        this.ag = this.N_();
        if (this.N_()) {
            this.aI = false;
        }
        this.q();
        if (this.npc.useMinecraftAI()) {
            this.cc.a((cmz)this);
        }
        if (((Boolean)this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, (Object)false)).booleanValue()) {
            if (this.cg > 0) {
                --this.cg;
            }
            evo axisalignedbb = this.bR() && !this.dc().dK() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            for (bsw entity : this.dP().a_((bsw)this, axisalignedbb)) {
                entity.b_((cmz)this);
            }
        }
        ++this.aT;
        this.gx().a();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || ((EntityPoseTrait)this.npc.getTraitNullable(EntityPoseTrait.class)).getPose() == null) {
            this.fV();
        }
    }

    public GameProfile gameProfile() {
        return this.gb();
    }

    public aln Q() {
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cO().aD(), this.cO().ah(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((bsw)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected avz o_() {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
    }

    protected avz d(brp damagesource) {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fh() {
        return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
    }

    public int cx() {
        return NMS.getFallDistance((NPC)this.npc, (int)super.cx());
    }

    public NPC getNPC() {
        return this.npc;
    }

    public eoc k_() {
        return Util.callPistonPushEvent((NPC)this.npc) ? eoc.d : super.k_();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public awg H() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public xp N() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return yd.a((xq)new yw.a(""));
        }
        return this.npc != null ? (xp)Messaging.minecraftComponentFromRawMessage((String)this.npc.getRawName()) : super.N();
    }

    public boolean a(brp damagesource, float f) {
        boolean damaged = super.a(damagesource, f);
        if (damaged && this.U) {
            this.U = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.U = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, aqu clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(zx.b);
            this.c = new EmptyPacketListener(minecraftServer, conn, this, new aru(this.gameProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setSkinFlags((byte)-1);
    }

    public boolean bE() {
        if (this.npc == null || this.ag || this.fL()) {
            return super.bE();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bA() {
        return this.npc == null ? super.bA() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
    }

    public void q(double strength, double dx, double dz) {
        NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt2 -> super.q((double)((float)evt2.getStrength()), evt2.getKnockbackVector().getX(), evt2.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.aI && this.jumpTicks == 0) {
                this.fj();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new evt((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), (float)this.dF());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(evt vec) {
        double x = this.du();
        double y = this.dw();
        double z = this.dA();
        this.a(vec);
        if (!this.npc.isProtected()) {
            this.a(this.du() - x, this.dw() - y, this.dA() - z, this.aI);
        }
    }

    public boolean q_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.q_();
        }
        return false;
    }

    public void h(bsw entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(bsw.c reason) {
        super.a(reason);
        this.Q().b();
    }

    public void setSkinFlags(byte flags) {
        this.ap().a(cmz.bV, (Object)flags);
    }

    public void l() {
        super.l();
        if (this.npc == null) {
            return;
        }
        if (NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES != null) {
            try {
                NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES.invoke(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.detectEquipmentUpdatesPublic();
        }
        float scale = this.ee();
        if (scale != this.bE) {
            this.bE = scale;
            this.j_();
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.fv()) {
            if (cur.b((cur)this.b(this.fw()), (cur)this.bz)) {
                this.bz = this.b(this.fw());
                this.a(this.bz);
            } else {
                this.fB();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a(evt vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((btr)this, vec3d);
        }
    }

    public boolean a(axf<enw> tagkey, double d0) {
        evt old = this.ds().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.h(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bZ = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity.ForwardingSkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (arg)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public SkinnableEntity getUnderlying() {
            return (SkinnableEntity)this.entity;
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

