/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPig;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;

public class PigController
extends MobEntityController {
    public PigController() {
        super(EntityPigNPC.class, EntityTypes.aV);
    }

    public Pig getBukkitEntity() {
        return (Pig)super.getBukkitEntity();
    }

    public static class EntityPigNPC
    extends EntityPig
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPigNPC(EntityTypes<? extends EntityPig> types, World level) {
            this(types, level, null);
        }

        public EntityPigNPC(EntityTypes<? extends EntityPig> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dR() {
            if (this.npc == null) {
                super.dR();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PigNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fw() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fw());
        }

        public int cR() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cR());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
        }

        public boolean T_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.T_(), (EntityInsentient)this);
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public boolean cm() {
            return this.npc == null ? super.cm() : false;
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean fe() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fe();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void a(WorldServer worldserver, EntityLightning entitylightning) {
            if (this.npc == null) {
                super.a(worldserver, entitylightning);
            }
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.m(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class PigNPC
    extends CraftPig
    implements ForwardingNPCHolder {
        public PigNPC(EntityPigNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPig)entity);
        }
    }
}

