/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntityMarkers<T> {
    private final Map<T, Entity> markers = Maps.newHashMap();
    private final NPCRegistry registry = CitizensAPI.getTemporaryNPCRegistry();
    private EntityType type;

    public EntityMarkers() {
        this(Util.getFallbackEntityType("SHULKER_BULLET", "LEASH_KNOT", "LEASH_HITCH"));
    }

    public EntityMarkers(EntityType type) {
        this.type = type;
    }

    public Entity createMarker(T marker, Location at) {
        Entity entity = this.spawnMarker(at.getWorld(), at);
        if (entity == null) {
            return null;
        }
        this.markers.put(marker, entity);
        return entity;
    }

    public void destroyMarkers() {
        this.registry.deregisterAll();
        this.markers.clear();
    }

    public void removeMarker(T marker) {
        Entity entity = this.markers.remove(marker);
        if (entity != null) {
            ((NPCHolder)entity).getNPC().destroy();
        }
    }

    public Entity spawnMarker(World world, Location at) {
        NPC npc = this.registry.createNPC(this.type, "");
        npc.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
        npc.spawn(at.clone().add(0.5, 0.0, 0.5), SpawnReason.CREATE);
        return npc.getEntity();
    }
}

