/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class TimeoutDecorator
implements Behavior {
    private final Behavior child;
    private final int maxTicks;
    private int ticksElapsed;

    public TimeoutDecorator(Behavior child, int maxTicks) {
        this.child = child;
        this.maxTicks = maxTicks;
    }

    @Override
    public void reset() {
        this.child.reset();
        this.ticksElapsed = 0;
    }

    @Override
    public BehaviorStatus run() {
        if (this.ticksElapsed >= this.maxTicks) {
            this.child.reset();
            return BehaviorStatus.FAILURE;
        }
        ++this.ticksElapsed;
        BehaviorStatus status = this.child.run();
        if (status != BehaviorStatus.RUNNING) {
            this.ticksElapsed = 0;
        }
        return status;
    }

    @Override
    public boolean shouldExecute() {
        return this.child.shouldExecute();
    }
}

