/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;

@TraitName(value="axolotltrait")
public class AxolotlTrait
extends Trait {
    @Persist
    private boolean playingDead = false;
    @Persist
    private Axolotl.Variant variant = null;

    public AxolotlTrait() {
        super("axolotltrait");
    }

    public Axolotl.Variant getVariant() {
        return this.variant;
    }

    public boolean isPlayingDead() {
        return this.playingDead;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)this.npc.getEntity();
            if (this.variant != null) {
                axolotl.setVariant(this.variant);
            }
            axolotl.setPlayingDead(this.playingDead);
        }
    }

    public void setPlayingDead(boolean playingDead) {
        this.playingDead = playingDead;
    }

    public void setVariant(Axolotl.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="axolotl (-d) (--variant variant)", desc="", modifiers={"axolotl"}, min=1, max=1, flags="d", permission="citizens.npc.axolotl")
    @Requirements(selected=true, ownership=true, types={EntityType.AXOLOTL})
    public static void axolotl(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) Axolotl.Variant variant) throws CommandException {
        AxolotlTrait trait = npc.getOrAddTrait(AxolotlTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.axolotl.invalid-variant", Util.listValuesPretty(Axolotl.Variant.values()));
            }
            trait.setVariant(variant);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.axolotl.variant-set", args.getFlag("variant"));
        }
        if (args.hasFlag('d')) {
            trait.setPlayingDead(!trait.isPlayingDead());
            output = output + ' ' + (trait.isPlayingDead() ? Messaging.tr("citizens.commands.npc.axolotl.playing-dead", npc.getName()) : Messaging.tr("citizens.commands.npc.axolotl.playing-dead-stopped", npc.getName()));
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

