/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.NMS;

@TraitName(value="gravity")
public class Gravity
extends Trait {
    @Persist(value="enabled")
    private boolean nogravity;

    public Gravity() {
        super("gravity");
    }

    private void applyImmediately() {
        if (this.nogravity && this.npc.getEntity() != null) {
            this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0));
            NMS.setNoGravity(this.npc.getEntity(), this.nogravity);
        }
    }

    public boolean hasGravity() {
        return !this.nogravity;
    }

    @Override
    public void onSpawn() {
        this.applyImmediately();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        NMS.setNoGravity(this.npc.getEntity(), this.nogravity);
    }

    public void setHasGravity(boolean hasGravity) {
        this.nogravity = !hasGravity;
    }

    public boolean toggle() {
        this.nogravity = !this.nogravity;
        this.applyImmediately();
        return this.nogravity;
    }
}

