/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.primitives.Ints;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.TriggerAddPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TriggerEditPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerEditPrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if ((input = input.toLowerCase().trim()).startsWith("remove_trigger")) {
            Waypoint waypoint = this.editor.getCurrentWaypoint();
            List<WaypointTrigger> triggers = waypoint.getTriggers();
            int idx = Ints.tryParse((String)input.replaceFirst("remove_trigger\\s*", ""));
            if (idx < triggers.size()) {
                triggers.remove(idx);
            }
            return this;
        }
        if (input.contains("add")) {
            context.setSessionData((Object)"said", (Object)false);
            return new TriggerAddPrompt();
        }
        return this;
    }

    public String getPromptText(ConversationContext context) {
        WaypointTrigger returned = (WaypointTrigger)context.getSessionData((Object)"created-trigger");
        if (returned != null) {
            if (this.editor.getCurrentWaypoint() != null) {
                this.editor.getCurrentWaypoint().addTrigger(returned);
                Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.add.added", returned.description());
            } else {
                Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            }
            context.setSessionData((Object)"created-trigger", null);
        }
        context.setSessionData((Object)"said", (Object)false);
        context.setSessionData((Object)"previous", (Object)this);
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.prompt", new Object[0]);
        if (this.editor.getCurrentWaypoint() != null) {
            this.editor.getCurrentWaypoint().describeTriggers((CommandSender)context.getForWhom());
        }
        return "";
    }

    public static Conversation start(Player player, WaypointEditor editor) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).addConversationAbandonedListener(event -> Messaging.sendTr((CommandSender)event.getContext().getForWhom(), "citizens.editors.waypoints.triggers.main.exit", new Object[0])).withEscapeSequence("exit").withEscapeSequence("triggers").withEscapeSequence("/npc path").withModality(false).withFirstPrompt((Prompt)new TriggerEditPrompt(editor)).buildConversation((Conversable)player);
        conversation.begin();
        return conversation;
    }
}

