/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R7.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R7.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPhantom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;

public class PhantomController
extends MobEntityController {
    public PhantomController() {
        super(EntityPhantomNPC.class, EntityTypes.aX);
    }

    public Phantom getBukkitEntity() {
        return (Phantom)super.getBukkitEntity();
    }

    public static class EntityPhantomNPC
    extends EntityPhantom
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerLook oldLookController;
        private ControllerMove oldMoveController;

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level) {
            this(types, level, null);
        }

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.cp;
                this.oldLookController = this.co;
                this.cp = new ControllerMove((EntityInsentient)this);
                this.co = new ControllerLook((EntityInsentient)this);
            }
        }

        public void d_() {
            super.d_();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.cp != this.oldMoveController) {
                    this.cp = this.oldMoveController;
                    this.co = this.oldLookController;
                }
                if (!this.npc.useMinecraftAI() && this.cp == this.oldMoveController) {
                    this.cp = new EntityMoveControl((EntityLiving)this);
                    this.co = new ControllerLook((EntityInsentient)this);
                }
                if (this.npc.isProtected()) {
                    this.e(0.0f);
                }
                this.npc.update();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof AbstractBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public void dW() {
            if (this.npc == null) {
                super.dW();
            }
        }

        protected SoundEffect W() {
            return NMSImpl.getSoundEffect(this.npc, super.W(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PhantomNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect fd() {
            return NMSImpl.getSoundEffect(this.npc, super.fd(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect h(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.h(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fF() {
            return NMS.getJumpPower(this.npc, super.fF());
        }

        public int cW() {
            return NMS.getFallDistance(this.npc, super.cW());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean S_() {
            return NMSImpl.isLeashed(this.npc, () -> super.S_(), (EntityInsentient)this);
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class PhantomNPC
    extends CraftPhantom
    implements ForwardingNPCHolder {
        public PhantomNPC(EntityPhantomNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPhantom)entity);
        }
    }
}

