/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai.tree;

import net.citizensnpcs.api.ai.tree.BehaviorRegistry;
import net.citizensnpcs.api.ai.tree.BehaviorSignals;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.InstantBehavior;
import net.citizensnpcs.api.expr.ExpressionRegistry;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CitizensBehaviorRegistry
extends BehaviorRegistry {
    public CitizensBehaviorRegistry(ExpressionRegistry expressionRegistry) {
        super(expressionRegistry);
    }

    public CitizensBehaviorRegistry(ExpressionRegistry expressionRegistry, BehaviorSignals signalManager) {
        super(expressionRegistry, signalManager);
    }

    @Override
    protected void registerDefaults() {
        super.registerDefaults();
        this.registerBehavior("print", (params, context) -> {
            String message = context.getArgOrParam(0, "message", params, null);
            if (message == null && params != null) {
                message = params.getString("");
            }
            if (message == null) {
                return null;
            }
            ExpressionRegistry.ExpressionValue messageHolder = this.getExpressionRegistry().parseValue(message);
            return () -> {
                String msg = messageHolder.evaluateAsString(context.getScope());
                Messaging.log(msg);
                return BehaviorStatus.SUCCESS;
            };
        });
        this.registerBehavior("say", (params, context) -> {
            String message = context.getArgOrParam(0, "message", params, null);
            if (message == null && params != null) {
                message = params.getString("");
            }
            if (message == null) {
                return null;
            }
            ExpressionRegistry.ExpressionValue messageHolder = this.getExpressionRegistry().parseValue(message);
            return () -> {
                NPC npc = context.getNPC();
                String msg = messageHolder.evaluateAsString(context.getScope());
                Util.runCommand(npc, null, "say " + msg, false, false);
                return BehaviorStatus.SUCCESS;
            };
        });
        this.registerBehavior("look", (params, context) -> {
            String xStr = context.getArgOrParam(0, "x", params, null);
            String yStr = context.getArgOrParam(1, "y", params, null);
            String zStr = context.getArgOrParam(2, "z", params, null);
            if (xStr == null || yStr == null || zStr == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue xHolder = this.getExpressionRegistry().parseValue(xStr);
            final ExpressionRegistry.ExpressionValue yHolder = this.getExpressionRegistry().parseValue(yStr);
            final ExpressionRegistry.ExpressionValue zHolder = this.getExpressionRegistry().parseValue(zStr);
            return new InstantBehavior(){

                @Override
                public BehaviorStatus run() {
                    NPC npc = context.getNPC();
                    double x = xHolder.evaluateAsNumber(context.getScope());
                    double y = yHolder.evaluateAsNumber(context.getScope());
                    double z = zHolder.evaluateAsNumber(context.getScope());
                    Location target = new Location(npc.getStoredLocation().getWorld(), x, y, z);
                    npc.faceLocation(target);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return context.getNPC().isSpawned();
                }
            };
        });
        this.registerBehavior("teleport", (params, context) -> {
            String xStr = context.getArgOrParam(0, "x", params, null);
            String yStr = context.getArgOrParam(1, "y", params, null);
            String zStr = context.getArgOrParam(2, "z", params, null);
            String worldStr = context.getArgOrParam(3, "z", params, null);
            if (xStr == null || yStr == null || zStr == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue xHolder = this.getExpressionRegistry().parseValue(xStr);
            final ExpressionRegistry.ExpressionValue yHolder = this.getExpressionRegistry().parseValue(yStr);
            final ExpressionRegistry.ExpressionValue zHolder = this.getExpressionRegistry().parseValue(zStr);
            final ExpressionRegistry.ExpressionValue worldHolder = worldStr == null ? null : this.getExpressionRegistry().parseValue(worldStr);
            return new InstantBehavior(){

                @Override
                public BehaviorStatus run() {
                    NPC npc = context.getNPC();
                    double x = xHolder.evaluateAsNumber(context.getScope());
                    double y = yHolder.evaluateAsNumber(context.getScope());
                    double z = zHolder.evaluateAsNumber(context.getScope());
                    Location target = new Location(worldHolder == null ? npc.getStoredLocation().getWorld() : Bukkit.getWorld((String)worldHolder.evaluateAsString(context.getScope())), x, y, z);
                    npc.teleport(target, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return context.getNPC().isSpawned();
                }
            };
        });
    }
}

