/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;

@TraitName(value="enderdragontrait")
public class EnderDragonTrait
extends Trait {
    @Persist
    private boolean destroyWalls;
    @Persist
    private EnderDragon.Phase phase;

    public EnderDragonTrait() {
        super("enderdragontrait");
    }

    public EnderDragon.Phase getPhase() {
        return this.phase;
    }

    public boolean isDestroyWalls() {
        return this.destroyWalls;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setDestroyWalls(boolean destroyWalls) {
        this.destroyWalls = destroyWalls;
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.phase = phase;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (!(this.npc.getEntity() instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)this.npc.getEntity();
        if (this.phase != null) {
            dragon.setPhase(this.phase);
        }
    }

    @Command(aliases={"npc"}, usage="enderdragon --phase [phase] --destroywalls [true|false]", desc="", modifiers={"enderdragon"}, min=1, max=1, permission="citizens.npc.enderdragon")
    @Requirements(ownership=true, selected=true, types={EntityType.ENDER_DRAGON})
    public static void enderdragon(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"phase"}) EnderDragon.Phase phase, @Flag(value={"destroywalls"}) Boolean destroyWalls) throws CommandException {
        EnderDragonTrait trait = npc.getOrAddTrait(EnderDragonTrait.class);
        if (phase != null) {
            trait.setPhase(phase);
        }
        if (destroyWalls != null) {
            trait.setDestroyWalls(destroyWalls);
        }
    }
}

