/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.function.Consumer;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitLookup;

public class IntMapTraitLookup
implements TraitLookup {
    private final Int2ReferenceOpenHashMap<Trait> traits = new Int2ReferenceOpenHashMap();

    @Override
    public void add(int typeId, Trait trait) {
        this.traits.put(typeId, (Object)trait);
    }

    @Override
    public void clear() {
        this.traits.clear();
    }

    @Override
    public void forEach(Consumer<Trait> visitor) {
        for (Trait trait : this.traits.values()) {
            if (trait == null) continue;
            visitor.accept(trait);
        }
    }

    @Override
    public Trait get(int typeId) {
        return (Trait)this.traits.get(typeId);
    }

    @Override
    public boolean has(int typeId) {
        return this.traits.containsKey(typeId);
    }

    @Override
    public Iterable<Trait> list() {
        return this.traits.values();
    }

    @Override
    public Trait remove(int typeId) {
        return (Trait)this.traits.remove(typeId);
    }
}

