/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class DatabaseStorage
implements Storage {
    private static final Traversed INVALID_TRAVERSAL = new Traversed(null, null, null);
    private final QueryRunner queryRunner = new QueryRunner();
    private final Map<String, Table> tables = Maps.newHashMap();
    private final Map<String, Traversed> traverseCache = Maps.newHashMap();
    private final String url;
    private final String username;
    private final String password;
    private static final Pattern INTEGER = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");

    public DatabaseStorage(String driver, String url, String username, String password) throws SQLException {
        this.url = url = "jdbc:" + url;
        this.username = username;
        this.password = password;
        DatabaseType.match(driver).load();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKey(Table from, Table to) {
        String fk = "fk_" + to.name;
        if (from.foreignKeys.containsKey(fk)) {
            return;
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("ALTER TABLE `" + from.name + "` ADD " + fk + " " + to.primaryKeyType);
            stmt.execute();
            DbUtils.closeQuietly(stmt);
            stmt = conn.prepareStatement("ALTER TABLE `" + from.name + "` ADD FOREIGN KEY (`" + fk + "`) REFERENCES `" + to.name + "` (`" + to.name + "_id" + "`)");
            stmt.execute();
            from.addForeignKey(fk, new ForeignKey(fk));
            DbUtils.closeQuietly(conn, stmt, null);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ensureRelation(String pk, Table from, final Table to) {
        Connection conn = this.getConnection();
        try {
            String existing = this.queryRunner.query(conn, "SELECT `fk_" + to.name + "` FROM " + from.name + " WHERE " + from.primaryKey + " = ?", new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.getString("fk_" + to.name);
                }
            }, pk);
            if (existing == null) {
                String generated = to.generateRow();
                this.queryRunner.update(conn, "UPDATE `" + from.name + "` SET `fk_" + to.name + "=?", (Object)generated);
                String string = generated;
                return string;
            }
            String string = existing;
            return string;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            DbUtils.closeQuietly(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table createTable(String name, int type, boolean autoIncrement) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Table t = this.tables.get(name);
        if (t != null) {
            return t;
        }
        String pk = name + "_id";
        String pkType = "";
        switch (type) {
            case 4: {
                pkType = "INTEGER NOT NULL";
                if (!autoIncrement) break;
                pkType = pkType + " AUTO_INCREMENT";
                break;
            }
            case 12: {
                pkType = "varchar(255) NOT NULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("type not supported");
            }
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        Table created = null;
        try {
            stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + name + "(`" + pk + "` " + pkType + ", PRIMARY KEY (`" + pk + "`))");
            stmt.execute();
            created = new Table().setName(name).setPrimaryKey(pk).setPrimaryKeyType(pkType);
            this.tables.put(name, created);
            DbUtils.closeQuietly(conn, stmt, null);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn, stmt, null);
        }
        return created;
    }

    private Connection getConnection() {
        try {
            return this.username.isEmpty() && this.password.isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DataKey getKey(String root) {
        return new DatabaseKey(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        this.tables.clear();
        this.traverseCache.clear();
        Connection conn = this.getConnection();
        try {
            ResultSet rs = conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME"), new Table());
            }
            rs.close();
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                entry.getValue().name = entry.getKey();
                rs = conn.getMetaData().getColumns(null, null, entry.getKey(), null);
                while (rs.next()) {
                    entry.getValue().columns.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                rs = conn.getMetaData().getPrimaryKeys(null, null, entry.getKey());
                while (rs.next()) {
                    entry.getValue().primaryKey = rs.getString("PK_NAME");
                    entry.getValue().setPrimaryKeyType(rs.getMetaData().getColumnTypeName(4));
                }
                rs.close();
                rs = conn.getMetaData().getImportedKeys(null, null, entry.getKey());
                while (rs.next()) {
                    ForeignKey key = new ForeignKey(rs.getString("PKCOLUMN_NAME"));
                    entry.getValue().foreignKeys.put(key.localColumn, key);
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn);
        }
    }

    @Override
    public void save() {
    }

    public String toString() {
        return "DatabaseStorage {url=" + this.url + ", username=" + this.username + ", password=" + this.password + "}";
    }

    private static interface ColumnProvider {
        public String getType();

        public Object getValue();
    }

    private class Table {
        final List<String> columns = Lists.newArrayList();
        final Map<String, ForeignKey> foreignKeys = Maps.newHashMap();
        String name;
        String primaryKey;
        String primaryKeyType;

        private Table() {
        }

        public Table setName(String tableName) {
            this.name = tableName;
            return this;
        }

        public void addForeignKey(String fk, ForeignKey foreignKey) {
            this.foreignKeys.put(fk, foreignKey);
            this.columns.add(fk);
        }

        public Table setPrimaryKeyType(String type) {
            this.primaryKeyType = type;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String generateRow() {
            block8: {
                String string;
                String vals = Joiner.on((String)", ").join(this.columns);
                StringBuilder nullBuilder = new StringBuilder();
                for (int i = 0; i < this.columns.size(); ++i) {
                    nullBuilder.append("NULL,");
                }
                String nulls = nullBuilder.substring(0, nullBuilder.length() - 2).toString();
                Connection conn = DatabaseStorage.this.getConnection();
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = conn.prepareStatement("INSERT INTO `" + this.name + "` (" + vals + ") VALUES (" + nulls + ")", 1);
                    stmt.executeQuery();
                    rs = stmt.getGeneratedKeys();
                    if (!rs.next()) {
                        String string2 = null;
                        DbUtils.closeQuietly(conn, stmt, rs);
                        return string2;
                    }
                    string = rs.getString(this.primaryKey);
                    DbUtils.closeQuietly(conn, stmt, rs);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    break block8;
                }
                finally {
                    DbUtils.closeQuietly(conn, stmt, rs);
                }
                return string;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insert(String primary) {
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                DatabaseStorage.this.queryRunner.update(conn, "INSERT INTO `" + this.name + "` (`" + this.primaryKey + "`) VALUES (?)", (Object)primary);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }

        public Table setPrimaryKey(String pk) {
            this.primaryKey = pk;
            return this;
        }

        public String toString() {
            return "Table {name=" + this.name + ", primaryKey=" + this.primaryKey + ", foreignKeys=" + this.foreignKeys + ", columns=" + this.columns + "}";
        }
    }

    private static class ForeignKey {
        final String localColumn;

        ForeignKey(String from) {
            this.localColumn = from;
        }
    }

    public static enum DatabaseType {
        H2("org.h2.Driver"),
        MYSQL("com.mysql.jdbc.Driver"),
        POSTGRE("org.postgresql.Driver"),
        SQLITE("org.sqlite.JDBC");

        private final String driver;
        private boolean loaded = false;

        private DatabaseType(String driver) {
            this.driver = driver;
        }

        public boolean load() {
            if (this.loaded) {
                return true;
            }
            if (DbUtils.loadDriver(this.driver)) {
                this.loaded = true;
            }
            return this.loaded;
        }

        public static DatabaseType match(String driver) {
            for (DatabaseType type : DatabaseType.values()) {
                if (!type.name().toLowerCase().contains(driver)) continue;
                return type;
            }
            return null;
        }
    }

    public class DatabaseKey
    extends DataKey {
        private final String current;

        private DatabaseKey(String root) {
            this.current = root;
        }

        private String createRelativeKey(String from) {
            if (from.isEmpty()) {
                return this.current;
            }
            if (from.charAt(0) == '.') {
                return this.current.isEmpty() ? from.substring(1, from.length()) : this.current + from;
            }
            return this.current.isEmpty() ? from : this.current + "." + from;
        }

        @Override
        public boolean getBoolean(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return false;
            }
            Boolean value = this.getValue(t, new ResultSetHandler<Boolean>(){

                @Override
                public Boolean handle(ResultSet rs) throws SQLException {
                    return rs.getBoolean(t.column);
                }
            });
            return value == null ? false : value;
        }

        @Override
        public double getDouble(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0.0;
            }
            Double value = this.getValue(t, new ResultSetHandler<Double>(){

                @Override
                public Double handle(ResultSet rs) throws SQLException {
                    return rs.getDouble(t.column);
                }
            });
            return value == null ? 0.0 : value;
        }

        @Override
        public int getInt(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0;
            }
            Integer value = this.getValue(t, new ResultSetHandler<Integer>(){

                @Override
                public Integer handle(ResultSet rs) throws SQLException {
                    return rs.getInt(t.column);
                }
            });
            return value == null ? 0 : value;
        }

        public List<DataKey> getIntegerSubKeys() {
            return null;
        }

        @Override
        public long getLong(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0L;
            }
            Long value = this.getValue(t, new ResultSetHandler<Long>(){

                @Override
                public Long handle(ResultSet rs) throws SQLException {
                    return rs.getLong(t.column);
                }
            });
            return value == null ? 0L : value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T getValue(Traversed t, ResultSetHandler<T> resultSetHandler) {
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                T t2 = DatabaseStorage.this.queryRunner.query(DatabaseStorage.this.getConnection(), "SELECT `" + t.column + "` FROM " + ((Traversed)t).found.name + " WHERE `" + ((Traversed)t).found.primaryKey + "`=?", resultSetHandler, t.key);
                return t2;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                T t3 = null;
                return t3;
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }

        @Override
        public Object getRaw(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return null;
            }
            Object value = this.getValue(t, new ResultSetHandler<Object>(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    return rs.getObject(t.column);
                }
            });
            return value;
        }

        @Override
        public DataKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new DatabaseKey(this.createRelativeKey(relative));
        }

        @Override
        public String getString(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return "";
            }
            String value = this.getValue(t, new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.getString(t.column);
                }
            });
            return value == null ? "" : value;
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            return null;
        }

        @Override
        public boolean keyExists(String key) {
            return this.traverse(this.createRelativeKey(key), false) != INVALID_TRAVERSAL;
        }

        @Override
        public String name() {
            Traversed t = this.traverse(this.current, true);
            return t.key != null ? t.key : ((Traversed)t).found.name;
        }

        private Traversed traverse(String path, boolean createRelations) {
            Traversed prev = (Traversed)DatabaseStorage.this.traverseCache.get(path);
            if (prev != null) {
                return prev;
            }
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)path), String.class);
            if (parts.length < 2) {
                return INVALID_TRAVERSAL;
            }
            Table table = null;
            String pk = null;
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                boolean contains = DatabaseStorage.this.tables.containsKey(part);
                if (table == null) {
                    if (!createRelations || i + 1 >= parts.length) {
                        return INVALID_TRAVERSAL;
                    }
                    pk = parts[++i];
                    int type = INTEGER.matcher(pk).matches() ? 4 : 12;
                    table = DatabaseStorage.this.createTable(part, type, false);
                    if (table == null) {
                        return INVALID_TRAVERSAL;
                    }
                    table.insert(pk);
                    continue;
                }
                if (!contains && DatabaseStorage.this.createTable(part, 4, true) == null) {
                    return INVALID_TRAVERSAL;
                }
                Table next = (Table)DatabaseStorage.this.tables.get(part);
                if (!table.foreignKeys.containsKey("fk_" + part)) {
                    if (!createRelations) {
                        return INVALID_TRAVERSAL;
                    }
                    DatabaseStorage.this.createForeignKey(table, next);
                }
                if ((pk = DatabaseStorage.this.ensureRelation(pk, table, next)) == null) {
                    return INVALID_TRAVERSAL;
                }
                table = next;
            }
            Traversed t = new Traversed(table, pk, parts[parts.length - 1]);
            DatabaseStorage.this.traverseCache.put(path, t);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeKey(String key) {
            Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return;
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (((Traversed)t).found.columns.contains(t.column)) {
                    DatabaseStorage.this.queryRunner.update(conn, "UPDATE `" + ((Traversed)t).found.name + "` SET `" + t.column + "`=? WHERE `" + ((Traversed)t).found.primaryKey + "`=?", null, t.key);
                } else {
                    DatabaseStorage.this.queryRunner.update(conn, "DELETE FROM `" + ((Traversed)t).found.name + "` WHERE `" + ((Traversed)t).found.primaryKey + "=?", (Object)t.key);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
            AbstractScriptEngine e = new AbstractScriptEngine(){

                @Override
                public Object eval(String script, ScriptContext context) throws ScriptException {
                    return null;
                }

                @Override
                public Object eval(Reader reader, ScriptContext context) throws ScriptException {
                    return null;
                }

                @Override
                public Bindings createBindings() {
                    return new SimpleBindings();
                }

                @Override
                public ScriptEngineFactory getFactory() {
                    return new ScriptEngineFactory(){

                        @Override
                        public String getEngineName() {
                            return null;
                        }

                        @Override
                        public String getEngineVersion() {
                            return null;
                        }

                        @Override
                        public List<String> getExtensions() {
                            return null;
                        }

                        @Override
                        public List<String> getMimeTypes() {
                            return null;
                        }

                        @Override
                        public List<String> getNames() {
                            return null;
                        }

                        @Override
                        public String getLanguageName() {
                            return null;
                        }

                        @Override
                        public String getLanguageVersion() {
                            return null;
                        }

                        @Override
                        public Object getParameter(String key) {
                            return null;
                        }

                        @Override
                        public String getMethodCallSyntax(String obj, String m, String ... args) {
                            return null;
                        }

                        @Override
                        public String getOutputStatement(String toDisplay) {
                            return null;
                        }

                        @Override
                        public String getProgram(String ... statements) {
                            return null;
                        }

                        @Override
                        public ScriptEngine getScriptEngine() {
                            return null;
                        }
                    };
                }
            };
        }

        @Override
        public void setBoolean(String key, final boolean value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "SMALLINT";
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setValue(String key, ColumnProvider value) {
            Traversed t = this.traverse(this.createRelativeKey(key), true);
            if (t == INVALID_TRAVERSAL) {
                throw new IllegalStateException("could not set " + value + " at " + key);
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (!((Traversed)t).found.columns.contains(t.column)) {
                    PreparedStatement stmt = conn.prepareStatement("ALTER TABLE `" + ((Traversed)t).found.name + "` ADD `" + t.column + "` " + value.getType());
                    stmt.execute();
                    DbUtils.closeQuietly(stmt);
                    ((Traversed)t).found.columns.add(t.column);
                }
                DatabaseStorage.this.queryRunner.update(conn, "UPDATE `" + ((Traversed)t).found.name + "` SET `" + t.column + "`= ? WHERE `" + ((Traversed)t).found.primaryKey + "` = ?", value.getValue(), t.key);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }

        @Override
        public void setDouble(String key, final double value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "DOUBLE";
                }
            });
        }

        @Override
        public void setInt(String key, final int value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "STRING";
                }
            });
        }

        @Override
        public void setLong(String key, final long value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "BIGINT";
                }
            });
        }

        @Override
        public void setRaw(String key, final Object value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "JAVA_OBJECT";
                }
            });
        }

        @Override
        public void setString(String key, final String value) {
            this.setValue(key, new ColumnProvider(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public String getType() {
                    return "VARCHAR";
                }
            });
        }
    }

    private static class Traversed {
        private final Table found;
        private final String key;
        private final String column;

        Traversed(Table found, String pk, String column) {
            this.found = found;
            this.key = pk;
            this.column = column;
        }
    }
}

