/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import net.citizensnpcs.api.jnbt.ByteTag;
import net.citizensnpcs.api.jnbt.CompoundTag;
import net.citizensnpcs.api.jnbt.DoubleTag;
import net.citizensnpcs.api.jnbt.IntTag;
import net.citizensnpcs.api.jnbt.LongTag;
import net.citizensnpcs.api.jnbt.NBTInputStream;
import net.citizensnpcs.api.jnbt.NBTOutputStream;
import net.citizensnpcs.api.jnbt.StringTag;
import net.citizensnpcs.api.jnbt.Tag;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.Bukkit;

public class NBTStorage
implements Storage {
    private final Map<String, Tag> root = Maps.newHashMap();
    private final File file;
    private final String name;

    public NBTStorage(String file) {
        this(file, "root");
    }

    public NBTStorage(String file, String name) {
        this.file = new File(file);
        if (!this.file.exists()) {
            this.create();
        }
        this.name = name;
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    @Override
    public DataKey getKey(String root) {
        return new NBTKey(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        NBTInputStream stream = null;
        try {
            stream = new NBTInputStream(new GZIPInputStream(new FileInputStream(this.file)));
            Tag tag = stream.readTag();
            if (tag == null || !(tag instanceof CompoundTag)) {
                Closeables.closeQuietly((Closeable)stream);
                return;
            }
            this.root.clear();
            this.root.putAll((Map<String, Tag>)((CompoundTag)tag).getValue());
            Closeables.closeQuietly((Closeable)stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            Closeables.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        NBTOutputStream stream = null;
        try {
            stream = new NBTOutputStream(new FileOutputStream(this.file));
            stream.writeTag(new CompoundTag(this.name, this.root));
            Closeables.closeQuietly((Closeable)stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            Closeables.closeQuietly(stream);
        }
    }

    public class NBTKey
    extends DataKey {
        private final String current;

        private String createRelativeKey(String from) {
            if (from.isEmpty()) {
                return this.current;
            }
            if (from.charAt(0) == '.') {
                return this.current.isEmpty() ? from.substring(1, from.length()) : this.current + from;
            }
            return this.current.isEmpty() ? from : this.current + "." + from;
        }

        public NBTKey(String root) {
            this.current = root;
        }

        @Override
        public boolean getBoolean(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof ByteTag)) {
                return false;
            }
            return ((ByteTag)tag).getValue() != 0;
        }

        private Map<String, Tag> findLastParent(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)key), String.class);
            Object map = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!map.containsKey(parts[i]) || !(map.get(parts[i]) instanceof CompoundTag)) {
                    return null;
                }
                map = ((CompoundTag)map.get(parts[i])).getValue();
            }
            return map;
        }

        private Tag findLastTag(String key) {
            return this.findLastTag(key, true);
        }

        private Tag findLastTag(String key, boolean relative) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)(relative ? this.createRelativeKey(key) : key)), String.class);
            Map<String, Tag> map = this.findLastParent(key);
            if (!map.containsKey(parts[parts.length - 1])) {
                return null;
            }
            return map.get(parts[parts.length - 1]);
        }

        @Override
        public double getDouble(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof DoubleTag)) {
                return 0.0;
            }
            return ((DoubleTag)tag).getValue();
        }

        @Override
        public int getInt(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof IntTag)) {
                return 0;
            }
            return ((IntTag)tag).getValue();
        }

        @Override
        public long getLong(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof LongTag)) {
                return 0L;
            }
            return ((LongTag)tag).getValue();
        }

        @Override
        public Object getRaw(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataKey getRelative(String relative) {
            return new NBTKey(this.createRelativeKey(relative));
        }

        @Override
        public String getString(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof StringTag)) {
                return "";
            }
            return ((StringTag)tag).getValue();
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ArrayList subKeys = Lists.newArrayList();
            Tag tag = this.findLastTag(this.current, false);
            if (!(tag instanceof CompoundTag)) {
                return subKeys;
            }
            for (String name : ((CompoundTag)tag).getValue().keySet()) {
                subKeys.add(new NBTKey(this.createRelativeKey(name)));
            }
            return subKeys;
        }

        @Override
        public boolean keyExists(String key) {
            return this.findLastTag(this.createRelativeKey(key)) != null;
        }

        @Override
        public String name() {
            int last = this.current.lastIndexOf(46);
            return this.current.substring(last == 0 ? 0 : last + 1);
        }

        @Override
        public void removeKey(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)key), String.class);
            Map<String, Tag> parent = this.findLastParent(this.createRelativeKey(key));
            parent.remove(parts[parts.length - 1]);
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.putTag(key, new ByteTag(this.getNameFor(key), (byte)(value ? 1 : 0)));
        }

        private String getNameFor(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            return parts[parts.length - 1];
        }

        private void putTag(String key, Tag tag) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            Object parent = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!parent.containsKey(parts[i]) || !(parent.get(parts[i]) instanceof CompoundTag)) {
                    parent.put(parts[i], new CompoundTag(parts[i]));
                }
                parent = ((CompoundTag)parent.get(parts[i])).getValue();
            }
            parent.put(tag.getName(), tag);
        }

        @Override
        public void setDouble(String key, double value) {
            this.putTag(key, new DoubleTag(this.getNameFor(key), value));
        }

        @Override
        public void setInt(String key, int value) {
            this.putTag(key, new IntTag(this.getNameFor(key), value));
        }

        @Override
        public void setLong(String key, long value) {
            this.putTag(key, new LongTag(this.getNameFor(key), value));
        }

        @Override
        public void setRaw(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setString(String key, String value) {
            this.putTag(key, new StringTag(this.getNameFor(key), value));
        }
    }
}

