/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@TraitName(value="forcefieldtrait")
public class ForcefieldTrait
extends Trait {
    @Persist
    private Double height;
    @Persist
    private Double strength;
    @Persist
    private Double verticalStrength;
    @Persist
    private Double width;

    public ForcefieldTrait() {
        super("forcefieldtrait");
    }

    public double getHeight() {
        return this.height == null ? this.npc.getEntity().getHeight() : this.height.doubleValue();
    }

    public double getStrength() {
        return this.strength == null ? 0.1 : this.strength;
    }

    public double getVerticalStrength() {
        return this.verticalStrength == null ? 0.0 : this.verticalStrength;
    }

    public double getWidth() {
        return this.width == null ? this.npc.getEntity().getWidth() : this.width.doubleValue();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        double height = this.getHeight();
        double width = this.getWidth();
        double strength = this.getStrength();
        Location base = this.npc.getEntity().getLocation();
        for (Player player : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(this.npc.getEntity(), new double[]{base.getX() - width / 1.9, base.getY(), base.getZ() - width / 1.9}, new double[]{base.getX() + width / 1.9, base.getY() + height, base.getZ() + width / 1.9})) {
            Vector diff = player.getLocation().subtract(base).toVector();
            if (diff.isZero()) continue;
            diff = diff.normalize().setY(this.getVerticalStrength());
            Vector force = player.getVelocity().add(diff.multiply(strength));
            player.setVelocity(force);
        }
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public void setStrength(Double strength) {
        this.strength = strength;
    }

    public void setVerticalStrength(Double verticalStrength) {
        this.verticalStrength = verticalStrength;
    }

    public void setWidth(Double width) {
        this.width = width;
    }
}

