/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.inventory.MainHand;

@TraitName(value="mannequintrait")
public class MannequinTrait
extends Trait {
    @Persist
    String description;
    @Persist
    boolean hideDescription = true;
    @Persist
    boolean immovable;
    @Persist
    private MainHand mainHand;

    public MannequinTrait() {
        super("mannequintrait");
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Mannequin) {
            Mannequin mannequin = (Mannequin)this.npc.getEntity();
            if (this.mainHand != null) {
                mannequin.setMainHand(this.mainHand);
            }
            mannequin.setDescription(this.description);
            mannequin.setImmovable(this.immovable);
            mannequin.setHideDescription(this.hideDescription);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHideDescription(boolean hide) {
        this.hideDescription = hide;
    }

    public void setImmovable(boolean immovable) {
        this.immovable = immovable;
    }

    public void setMainHand(MainHand hand) {
        this.mainHand = hand;
    }

    @Command(aliases={"npc"}, usage="mannequin --hide_description [true|false] --immovable [true|false] --description [description] --main_hand [LEFT|RIGHT]", desc="", modifiers={"mannequin"}, min=1, max=1, permission="citizens.npc.mannequin")
    @Requirements(selected=true, ownership=true, types={EntityType.MANNEQUIN})
    public static void cow(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"description"}) String description, @Flag(value={"immovable"}) Boolean immovable, @Flag(value={"hide_description"}) Boolean hideDescription, @Flag(value={"main_hand"}) MainHand mainHand) throws CommandException {
        MannequinTrait trait = npc.getOrAddTrait(MannequinTrait.class);
        String output = "";
        if (description != null) {
            trait.setDescription(description);
        }
        if (hideDescription != null) {
            trait.setHideDescription(hideDescription);
        }
        if (immovable != null) {
            trait.setImmovable(immovable);
        }
        if (mainHand != null) {
            trait.setMainHand(mainHand);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

