/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.TalkableEntity;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.EntityTargetNPCEvent;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCMoveEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.NPCVehicleDamageEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.api.util.schedulers.SchedulerRunnable;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinUpdateTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HomeTrait;
import net.citizensnpcs.trait.TargetableTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.util.Vector;

public class EventListen
implements Listener {
    private Listener chunkEventListener;
    private Citizens plugin;
    private final SkinUpdateTracker skinUpdateTracker;
    private final ListMultimap<ChunkCoord, NPC> toRespawn = ArrayListMultimap.create((int)64, (int)4);
    private static boolean SUPPORT_STOP_USE_ITEM = true;

    EventListen(final Citizens plugin) {
        this.plugin = plugin;
        this.skinUpdateTracker = new SkinUpdateTracker();
        try {
            Class.forName("org.bukkit.event.entity.EntityPickupItemEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public void onEntityPickupItem(EntityPickupItemEvent event) {
                    if (event.getItem() instanceof NPCHolder) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        catch (Throwable ex) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
                    if (event.getItem() instanceof NPCHolder) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        try {
            Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onEntitiesLoad(EntitiesLoadEvent event) {
                    EventListen.this.loadNPCs((ChunkEvent)event);
                }

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onEntitiesUnload(EntitiesUnloadEvent event) {
                    ArrayList toDespawn = Lists.newArrayList(plugin.getLocationLookup().getNearbyNPCs(event.getWorld(), new double[]{(double)(event.getChunk().getX() << 4) - 0.5, 0.0, (double)(event.getChunk().getZ() << 4) - 0.5}, new double[]{(double)(event.getChunk().getX() + 1 << 4) + 0.5, 256.0, (double)(event.getChunk().getZ() + 1 << 4) + 0.5}));
                    for (Entity entity : event.getEntities()) {
                        NPC npc = plugin.getNPCRegistry().getNPC(entity);
                        if (npc == null || npc.getEntity() == null || toDespawn.contains(npc)) continue;
                        toDespawn.add(npc);
                    }
                    if (toDespawn.isEmpty()) {
                        return;
                    }
                    EventListen.this.unloadNPCs((ChunkEvent)event, toDespawn);
                }
            }, (Plugin)plugin);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.event.entity.EntityTransformEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onEntityTransform(EntityTransformEvent event) {
                    NPC npc = plugin.getNPCRegistry().getNPC(event.getEntity());
                    if (npc == null) {
                        return;
                    }
                    if (npc.isProtected()) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        Class<?> kbc = null;
        try {
            kbc = Class.forName("com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (kbc != null) {
            this.registerKnockbackEvent(kbc);
        }
        Class<?> pbeac = null;
        try {
            pbeac = Class.forName("io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (pbeac != null) {
            this.registerPushEvent(pbeac);
        }
        Class<?> paperEntityMoveEventClazz = null;
        try {
            paperEntityMoveEventClazz = Class.forName("io.papermc.paper.event.entity.EntityMoveEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (paperEntityMoveEventClazz != null) {
            this.registerMoveEvent(paperEntityMoveEventClazz);
        }
    }

    private void checkCreationEvent(CommandSenderCreateNPCEvent event) {
        int maxChecks;
        if (event.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int limit = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (int i = maxChecks = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); i >= 0; --i) {
            if (!event.getCreator().hasPermission("citizens.npc.limit." + i)) continue;
            limit = i;
            break;
        }
        if (limit < 0) {
            return;
        }
        int owned = 0;
        for (NPC npc : this.plugin.getNPCRegistry()) {
            if (event.getNPC().equals(npc) || !npc.hasTrait(Owner.class) || !npc.getTraitNullable(Owner.class).isOwnedBy(event.getCreator())) continue;
            ++owned;
        }
        int wouldOwn = owned + 1;
        if (wouldOwn > limit) {
            event.setCancelled(true);
            event.setCancelReason(Messaging.tr("citizens.limits.over-npc-limit", limit));
        }
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat(this.plugin.getNPCRegistries()), Objects::nonNull);
    }

    void loadNPCs(ChunkEvent event) {
        ChunkCoord coord = new ChunkCoord(event.getChunk());
        Runnable runnable = () -> this.respawnAllFromCoord(coord, (Event)event);
        if (event instanceof Cancellable) {
            runnable.run();
        } else {
            Chunk chunk = event.getChunk();
            CitizensAPI.getScheduler().runRegionTask(chunk.getWorld(), chunk.getX(), chunk.getZ(), runnable);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.chunkEventListener != null) {
            return;
        }
        this.loadNPCs((ChunkEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (this.chunkEventListener != null) {
            return;
        }
        ArrayList toDespawn = Lists.newArrayList(this.plugin.getLocationLookup().getNearbyNPCs(event.getWorld(), new double[]{(double)(event.getChunk().getX() << 4) - 0.5, 0.0, (double)(event.getChunk().getZ() << 4) - 0.5}, new double[]{(double)(event.getChunk().getX() + 1 << 4) + 0.5, 256.0, (double)(event.getChunk().getZ() + 1 << 4) + 0.5}));
        if (SpigotUtil.getVersion()[1] < 21) {
            for (Entity entity : event.getChunk().getEntities()) {
                NPC npc = this.plugin.getNPCRegistry().getNPC(entity);
                if (npc == null || npc.getEntity() == null || toDespawn.contains(npc)) continue;
                toDespawn.add(npc);
            }
        }
        if (toDespawn.isEmpty()) {
            return;
        }
        this.unloadNPCs((ChunkEvent)event, toDespawn);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCitizensReload(CitizensPreReloadEvent event) {
        this.skinUpdateTracker.reset();
        this.toRespawn.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommandSenderCreateNPC(CommandSenderCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        if (npc.getEntity() instanceof Snowman) {
            boolean formSnow = npc.hasTrait(SnowmanTrait.class) ? npc.getTraitNullable(SnowmanTrait.class).shouldFormSnow() : npc.useMinecraftAI();
            event.setCancelled(!formSnow);
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        NPCCombustEvent npcCombustEvent = event instanceof EntityCombustByEntityEvent ? new NPCCombustByEntityEvent((EntityCombustByEntityEvent)event, npc) : (event instanceof EntityCombustByBlockEvent ? new NPCCombustByBlockEvent((EntityCombustByBlockEvent)event, npc) : new NPCCombustEvent(event, npc));
        if (npc.isProtected()) {
            npcCombustEvent.setCancelled(true);
        }
        Bukkit.getPluginManager().callEvent((Event)npcCombustEvent);
        if (npcCombustEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            if (event instanceof EntityDamageByEntityEvent) {
                npc = this.plugin.getNPCRegistry().getNPC(((EntityDamageByEntityEvent)event).getDamager());
                if (npc == null) {
                    return;
                }
                event.setCancelled(npc.data().get(NPC.Metadata.DAMAGE_OTHERS, Boolean.valueOf(true)) == false);
                NPCDamageEntityEvent damageEvent = new NPCDamageEntityEvent(npc, (EntityDamageByEntityEvent)event);
                Bukkit.getPluginManager().callEvent((Event)damageEvent);
                if (damageEvent.isCancelled()) {
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (npc.isProtected()) {
            event.setCancelled(true);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent damageEvent = new NPCDamageByEntityEvent(npc, (EntityDamageByEntityEvent)event);
            Bukkit.getPluginManager().callEvent((Event)damageEvent);
            if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
                return;
            }
            Player damager = (Player)damageEvent.getDamager();
            if (npc.hasTrait(ClickRedirectTrait.class) && (npc = npc.getTraitNullable(ClickRedirectTrait.class).getRedirectToNPC()) == null) {
                return;
            }
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
            if (leftClickEvent.isCancelled()) {
                return;
            }
            if (npc.hasTrait(CommandTrait.class)) {
                npc.getTraitNullable(CommandTrait.class).dispatch(damager, CommandTrait.Hand.LEFT);
            }
        } else {
            NPCDamageEvent npcDamageEvent = event instanceof EntityDamageByBlockEvent ? new NPCDamageByBlockEvent(npc, (EntityDamageByBlockEvent)event) : new NPCDamageEvent(npc, event);
            Bukkit.getPluginManager().callEvent((Event)npcDamageEvent);
            if (npcDamageEvent.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onEntityDeath(EntityDeathEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        if (!npc.data().get(NPC.Metadata.DROPS_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            event.getDrops().clear();
        }
        Location location = npc.getStoredLocation();
        Bukkit.getPluginManager().callEvent((Event)new NPCDeathEvent(npc, event));
        npc.despawn(DespawnReason.DEATH);
        int delay = npc.data().get(NPC.Metadata.RESPAWN_DELAY, Integer.valueOf(-1));
        if (delay < 0) {
            return;
        }
        int deathAnimationTicks = event.getEntity() instanceof LivingEntity ? 20 : 2;
        CitizensAPI.getScheduler().runRegionTaskLater(location, () -> {
            if (!npc.isSpawned() && npc.getOwningRegistry().getByUniqueId(npc.getUniqueId()) == npc) {
                Location respawn = location;
                if (npc.hasTrait(HomeTrait.class) && npc.getOrAddTrait(HomeTrait.class).getHomeLocation() != null) {
                    respawn = npc.getOrAddTrait(HomeTrait.class).getHomeLocation();
                }
                npc.spawn(respawn, SpawnReason.TIMED_RESPAWN);
            }
        }, delay + deathAnimationTicks);
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null || npc.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        event.setCancelled(true);
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        event.getTo().getChunk();
        npc.spawn(event.getTo(), SpawnReason.RESPAWN);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() && this.plugin.getNPCRegistry().isNPC((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getEntity());
        if (npc == null || !npc.isProtected()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity targeted = event.getTarget();
        NPC npc = this.plugin.getNPCRegistry().getNPC(targeted);
        Entity targeter = event.getEntity();
        if (npc != null) {
            EntityTargetNPCEvent targetNPCEvent = new EntityTargetNPCEvent(event, npc);
            targetNPCEvent.setCancelled(!npc.getOrAddTrait(TargetableTrait.class).isTargetable());
            Bukkit.getPluginManager().callEvent((Event)targetNPCEvent);
            if (targetNPCEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (event.isCancelled() || !(targeter instanceof Mob)) {
                return;
            }
            npc.getOrAddTrait(TargetableTrait.class).addTargeter(targeter.getUniqueId());
        } else if (targeter instanceof Mob) {
            NPC prev = this.plugin.getNPCRegistry().getNPC((Entity)((Mob)targeter).getTarget());
            if (prev == null) {
                return;
            }
            prev.getOrAddTrait(TargetableTrait.class).removeTargeter(targeter.getUniqueId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onNavigationBegin(NavigationBeginEvent event) {
        this.skinUpdateTracker.onNPCNavigationBegin(event.getNPC());
    }

    @EventHandler
    public void onNavigationComplete(NavigationCompleteEvent event) {
        this.skinUpdateTracker.onNPCNavigationComplete(event.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent event) {
        if (event.getReason() == DespawnReason.PLUGIN || event.getReason() == DespawnReason.REMOVAL || event.getReason() == DespawnReason.RELOAD) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Preventing further respawns of", (Object)event.getNPC(), new Object[]{"due to DespawnReason." + (Object)((Object)event.getReason())}));
            this.toRespawn.values().remove(event.getNPC());
        } else {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Removing", (Object)event.getNPC(), new Object[]{"from skin tracker due to DespawnReason." + event.getReason().name()}));
        }
        this.skinUpdateTracker.onNPCDespawn(event.getNPC());
    }

    @EventHandler
    public void onNPCKnockback(NPCKnockbackEvent event) {
        event.setCancelled(event.getNPC().isProtected());
        if (event.getNPC().data().has(NPC.Metadata.KNOCKBACK)) {
            event.setCancelled(event.getNPC().data().get(NPC.Metadata.KNOCKBACK, Boolean.valueOf(true)) == false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCLinkToPlayer(NPCLinkToPlayerEvent event) {
        NPC npc = event.getNPC();
        if (npc.isSpawned()) {
            NMS.markPoseDirty(npc.getEntity());
        }
        if (npc.getEntity() instanceof SkinnableEntity) {
            SkinnableEntity skinnable = (SkinnableEntity)npc.getEntity();
            if (Skin.hasSkin(skinnable.getSkinName())) {
                Skin.get(skinnable).apply(skinnable);
            }
            if (npc.getEntity() instanceof Player) {
                this.onNPCPlayerLinkToPlayer(event);
            }
        }
        if (npc.data().has(NPC.Metadata.HOLOGRAM_RENDERER)) {
            HologramTrait.HologramRenderer hr = (HologramTrait.HologramRenderer)npc.data().get(NPC.Metadata.HOLOGRAM_RENDERER);
            CitizensAPI.getScheduler().runEntityTaskLater((Entity)event.getPlayer(), () -> hr.onSeenByPlayer(npc, event.getPlayer()), 2L);
        }
    }

    @EventHandler
    public void onNPCNeedsRespawn(NPCNeedsRespawnEvent event) {
        ChunkCoord coord = event.getSpawnLocation();
        if (this.toRespawn.containsEntry((Object)coord, (Object)event.getNPC())) {
            return;
        }
        Messaging.debug("Stored", event.getNPC(), "for respawn from NPCNeedsRespawnEvent");
        this.toRespawn.put((Object)coord, (Object)event.getNPC());
    }

    private void onNPCPlayerLinkToPlayer(NPCLinkToPlayerEvent event) {
        Entity tracker = event.getNPC().getEntity();
        boolean resetYaw = event.getNPC().data().get(NPC.Metadata.RESET_YAW_ON_SPAWN, Boolean.valueOf(Settings.Setting.RESET_YAW_ON_SPAWN.asBoolean()));
        boolean sendTabRemove = NMS.sendTabListAdd(event.getPlayer(), (Player)tracker);
        if (!sendTabRemove || !event.getNPC().shouldRemoveFromTabList()) {
            NMS.sendRotationPacket(tracker, (Iterable<Player>)ImmutableList.of((Object)event.getPlayer()), null, null, Float.valueOf(NMS.getHeadYaw(tracker)));
            if (resetYaw) {
                CitizensAPI.getScheduler().runEntityTask(tracker, () -> PlayerAnimation.ARM_SWING.play((Player)tracker, event.getPlayer()));
            }
            return;
        }
        CitizensAPI.getScheduler().runRegionTaskLater(tracker.getLocation(), () -> {
            if (!tracker.isValid() || !event.getPlayer().isValid()) {
                return;
            }
            NMS.sendTabListRemove(event.getPlayer(), (Player)tracker);
            NMS.sendRotationPacket(tracker, (Iterable<Player>)ImmutableList.of((Object)event.getPlayer()), null, null, Float.valueOf(NMS.getHeadYaw(tracker)));
            if (resetYaw) {
                PlayerAnimation.ARM_SWING.play((Player)tracker, event.getPlayer());
            }
        }, Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCRemove(NPCRemoveEvent event) {
        this.toRespawn.values().remove(event.getNPC());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCSeenByPlayer(NPCSeenByPlayerEvent event) {
        ClickRedirectTrait crt;
        NPC npc = event.getNPC();
        PlayerFilter pf = npc.getTraitNullable(PlayerFilter.class);
        if (pf != null) {
            event.setCancelled(pf.onSeenByPlayer(event.getPlayer()));
        }
        if ((crt = npc.getTraitNullable(ClickRedirectTrait.class)) != null) {
            if (npc.data().has(NPC.Metadata.HOLOGRAM_RENDERER) && !crt.getRedirectToNPC().getOrAddTrait(HologramTrait.class).onSeenByPlayer(event.getPlayer())) {
                event.setCancelled(true);
                return;
            }
            npc = crt.getRedirectToNPC();
        }
        if ((pf = npc.getTraitNullable(PlayerFilter.class)) != null) {
            event.setCancelled(pf.onSeenByPlayer(event.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent event) {
        this.skinUpdateTracker.onNPCSpawn(event.getNPC());
        Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Removing respawns of", (Object)event.getNPC(), new Object[]{"due to SpawnReason." + (Object)((Object)event.getReason())}));
        this.toRespawn.values().remove(event.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCSpeak(NPCSpeechEvent event) {
        SpeechContext context = event.getContext();
        if (context.getTalker() == null) {
            return;
        }
        NPC npc = this.plugin.getNPCRegistry().getNPC(context.getTalker().getEntity());
        if (npc == null) {
            return;
        }
        if (!context.hasRecipients()) {
            String text = Settings.Setting.CHAT_FORMAT.asString().replace("<text>", context.getMessage());
            EventListen.talkToBystanders(npc, text, context);
            return;
        }
        if (context.size() <= 1) {
            String text = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<text>", context.getMessage());
            String targetName = "";
            for (Talkable talkable : context) {
                talkable.talkTo(context, text);
                targetName = talkable.getName();
            }
            if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
                return;
            }
            String bystanderText = Settings.Setting.CHAT_FORMAT_TO_BYSTANDERS.asString().replace("<target>", targetName).replace("<text>", context.getMessage());
            EventListen.talkToBystanders(npc, bystanderText, context);
            return;
        }
        String text = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<text>", context.getMessage());
        ArrayList<String> targetNames = new ArrayList<String>();
        for (Talkable talkable : context) {
            talkable.talkTo(context, text);
            targetNames.add(talkable.getName());
        }
        if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
            return;
        }
        String targets = "";
        int max = Settings.Setting.CHAT_MAX_NUMBER_OF_TARGETS.asInt();
        String[] format = Settings.Setting.CHAT_MULTIPLE_TARGETS_FORMAT.asString().split("\\|");
        if (format.length != 4) {
            Messaging.severe("npc.chat.options.multiple-targets-format invalid!");
        }
        if (max == 1) {
            targets = format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[3];
        } else if (max == 2 || targetNames.size() == 2) {
            targets = targetNames.size() == 2 ? format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[2].replace("<target>", (CharSequence)targetNames.get(1)) : format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[1].replace("<target>", (CharSequence)targetNames.get(1)) + format[3];
        } else if (max >= 3) {
            targets = format[0].replace("<target>", (CharSequence)targetNames.get(0));
            int x = 1;
            for (x = 1; x < max - 1 && targetNames.size() - 1 != x; ++x) {
                targets = targets + format[1].replace("<npc>", (CharSequence)targetNames.get(x));
            }
            targets = targetNames.size() == max ? targets + format[2].replace("<npc>", (CharSequence)targetNames.get(x)) : targets + format[3];
        }
        String bystanderText = Settings.Setting.CHAT_FORMAT_WITH_TARGETS_TO_BYSTANDERS.asString().replace("<targets>", targets).replace("<text>", context.getMessage());
        EventListen.talkToBystanders(npc, bystanderText, context);
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.skinUpdateTracker.removePlayer(event.getPlayer().getUniqueId());
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 20L, true);
        if (this.plugin.getNPCRegistry().getNPC((Entity)event.getPlayer()) == null) {
            return;
        }
        CitizensAPI.getScheduler().runEntityTaskLater((Entity)event.getPlayer(), () -> {
            NMS.replaceTracker((Entity)event.getPlayer());
            NMS.removeFromServerPlayerList(event.getPlayer());
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        if (npc.requiresNameHologram() && event.getDeathMessage() != null) {
            event.setDeathMessage(event.getDeathMessage().replace(event.getEntity().getName(), npc.getFullName()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (this.plugin.getNPCRegistry().isNPC(event.getCaught()) && this.plugin.getNPCRegistry().getNPC(event.getCaught()).isProtected()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getRightClicked());
        if (npc == null || Util.isOffHand(event)) {
            return;
        }
        ClickRedirectTrait crt = npc.getTraitNullable(ClickRedirectTrait.class);
        if (crt != null && (npc = crt.getRedirectToNPC()) == null) {
            return;
        }
        Player player = event.getPlayer();
        NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
        if (event.getPlayer().getItemInHand().getType() == Material.NAME_TAG) {
            rightClickEvent.setCancelled(npc.isProtected());
        }
        Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
        if (rightClickEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (npc.hasTrait(CommandTrait.class)) {
            npc.getTraitNullable(CommandTrait.class).dispatch(player, CommandTrait.Hand.RIGHT);
            rightClickEvent.setDelayedCancellation(true);
        }
        if (rightClickEvent.isDelayedCancellation()) {
            event.setCancelled(true);
        }
        if (event.isCancelled() && SUPPORT_STOP_USE_ITEM) {
            try {
                PlayerAnimation.STOP_USE_ITEM.play(player);
                CitizensAPI.getScheduler().runEntityTask((Entity)player, () -> PlayerAnimation.STOP_USE_ITEM.play(player));
            }
            catch (UnsupportedOperationException e) {
                SUPPORT_STOP_USE_ITEM = false;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), Settings.Setting.INITIAL_PLAYER_JOIN_SKIN_PACKET_DELAY.asTicks(), true);
        this.plugin.getLocationLookup().onJoin(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        boolean leashProtected = npc.isProtected();
        if (npc.data().get(NPC.Metadata.LEASH_PROTECTED, Boolean.valueOf(leashProtected)).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.skinUpdateTracker.onPlayerMove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        NPC npc;
        Editor.leave(event.getPlayer());
        if (event.getPlayer().isInsideVehicle() && (npc = this.plugin.getNPCRegistry().getNPC(event.getPlayer().getVehicle())) != null) {
            event.getPlayer().leaveVehicle();
        }
        this.skinUpdateTracker.removePlayer(event.getPlayer().getUniqueId());
        this.plugin.getLocationLookup().onQuit(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 15L, true);
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        if (npc.isProtected()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 15L, true);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        PluginDescriptionFile file = event.getPlugin().getDescription();
        for (String depend : Iterables.concat((Iterable)file.getDepend(), (Iterable)file.getSoftDepend())) {
            if (!depend.equalsIgnoreCase("citizens") || !this.plugin.isEnabled()) continue;
            this.plugin.onDependentPluginDisable();
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        for (LivingEntity entity : event.getAffectedEntities()) {
            NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)entity);
            if (npc == null || !npc.isProtected()) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHit(final ProjectileHitEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getHitEntity());
        if (npc != null && npc.isProtected() && event.getEntityType().name().contains("WIND_CHARGE")) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getEntity() instanceof FishHook)) {
            return;
        }
        NMS.removeHookIfNecessary((FishHook)event.getEntity());
        new SchedulerRunnable(){
            int n = 0;

            @Override
            public void run() {
                if (this.n++ > 5 || !EventListen.this.plugin.isEnabled()) {
                    this.cancel();
                    return;
                }
                NMS.removeHookIfNecessary((FishHook)event.getEntity());
            }
        }.runEntityTaskTimer(this.plugin, (Entity)event.getEntity(), null, 0L, 1L);
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getVehicle());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.isProtected());
        NPCVehicleDamageEvent damageEvent = new NPCVehicleDamageEvent(npc, event);
        Bukkit.getPluginManager().callEvent((Event)damageEvent);
        if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
            return;
        }
        Player damager = (Player)damageEvent.getDamager();
        NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
        Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
        if (npc.hasTrait(CommandTrait.class)) {
            npc.getTraitNullable(CommandTrait.class).dispatch(damager, CommandTrait.Hand.LEFT);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getVehicle());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.isProtected());
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        NPC npc = this.plugin.getNPCRegistry().getNPC((Entity)event.getVehicle());
        NPC rider = this.plugin.getNPCRegistry().getNPC(event.getEntered());
        if (npc == null) {
            if (rider != null && rider.isProtected() && (event.getVehicle().getType().name().contains("BOAT") || event.getVehicle() instanceof Minecart)) {
                event.setCancelled(true);
            }
            return;
        }
        if (rider != null || !(npc instanceof Vehicle)) {
            return;
        }
        if (!npc.hasTrait(Controllable.class) || !npc.getTraitNullable(Controllable.class).isEnabled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        for (NPC npc : this.getAllNPCs()) {
            if (npc == null || !npc.isSpawned() || !npc.getEntity().getWorld().equals((Object)event.getWorld())) continue;
            boolean despawned = npc.despawn(DespawnReason.WORLD_UNLOAD);
            if (event.isCancelled() || !despawned) {
                for (ChunkCoord coord : Lists.newArrayList((Iterable)this.toRespawn.keySet())) {
                    if (!event.getWorld().getUID().equals(coord.worldUUID)) continue;
                    this.respawnAllFromCoord(coord, (Event)event);
                }
                event.setCancelled(true);
                return;
            }
            if (!npc.isSpawned()) continue;
            this.toRespawn.put((Object)new ChunkCoord(npc.getEntity().getLocation()), (Object)npc);
            Messaging.debug("Despawned", npc, "due to world unload at", event.getWorld().getName());
        }
        this.plugin.getLocationLookup().onWorldUnload(event);
    }

    private void registerKnockbackEvent(Class<?> kbc) {
        try {
            HandlerList handlers = (HandlerList)kbc.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            Method getEntity = kbc.getMethod("getEntity", new Class[0]);
            Method getHitBy = kbc.getMethod("getHitBy", new Class[0]);
            Method getKnockbackStrength = kbc.getMethod("getKnockbackStrength", new Class[0]);
            Method getAcceleration = kbc.getMethod("getAcceleration", new Class[0]);
            handlers.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                try {
                    if (event.getClass() != kbc) {
                        return;
                    }
                    Entity entity = (Entity)getEntity.invoke((Object)event, new Object[0]);
                    if (!(entity instanceof NPCHolder)) {
                        return;
                    }
                    NPC npc = ((NPCHolder)entity).getNPC();
                    Entity hitBy = (Entity)getHitBy.invoke((Object)event, new Object[0]);
                    float strength = ((Float)getKnockbackStrength.invoke((Object)event, new Object[0])).floatValue();
                    Vector vector = (Vector)getAcceleration.invoke((Object)event, new Object[0]);
                    NPCKnockbackEvent kb = new NPCKnockbackEvent(npc, strength, vector, hitBy);
                    Bukkit.getPluginManager().callEvent((Event)kb);
                    ((Cancellable)event).setCancelled(kb.isCancelled());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }, EventPriority.NORMAL, (Plugin)this.plugin, true));
        }
        catch (Throwable ex) {
            Messaging.severe("Error registering knockback event forwarder");
            ex.printStackTrace();
        }
    }

    private void registerMoveEvent(Class<?> clazz) {
        try {
            HandlerList handlers = (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            Method getEntity = clazz.getMethod("getEntity", new Class[0]);
            Method getFrom = clazz.getMethod("getFrom", new Class[0]);
            Method getTo = clazz.getMethod("getTo", new Class[0]);
            handlers.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                if (NPCMoveEvent.getHandlerList().getRegisteredListeners().length == 0 || event.getClass() != clazz) {
                    return;
                }
                try {
                    Entity entity = (Entity)getEntity.invoke((Object)event, new Object[0]);
                    if (!(entity instanceof NPCHolder)) {
                        return;
                    }
                    NPC npc = ((NPCHolder)entity).getNPC();
                    Location from = (Location)getFrom.invoke((Object)event, new Object[0]);
                    Location to = ((Location)getTo.invoke((Object)event, new Object[0])).clone();
                    NPCMoveEvent npcMoveEvent = new NPCMoveEvent(npc, from, to);
                    Bukkit.getPluginManager().callEvent((Event)npcMoveEvent);
                    if (npcMoveEvent.isCancelled()) {
                        Location eventFrom = npcMoveEvent.getFrom();
                        CitizensAPI.getScheduler().runEntityTaskLater(entity, () -> SpigotUtil.teleportAsync(entity, eventFrom), 1L);
                        return;
                    }
                    Location eventTo = npcMoveEvent.getTo();
                    if (eventTo.getWorld() != to.getWorld() || eventTo.distance(to) > 0.001) {
                        CitizensAPI.getScheduler().runEntityTaskLater(entity, () -> SpigotUtil.teleportAsync(entity, eventTo), 1L);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }, EventPriority.NORMAL, (Plugin)this.plugin, true));
        }
        catch (Throwable ex) {
            Messaging.severe("Error registering move event forwarder");
            ex.printStackTrace();
        }
    }

    private void registerPushEvent(Class<?> clazz) {
        try {
            HandlerList handlers = (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            Method getEntity = clazz.getMethod("getEntity", new Class[0]);
            Method getPushedBy = clazz.getMethod("getPushedBy", new Class[0]);
            Method getAcceleration = clazz.getMethod("getAcceleration", new Class[0]);
            handlers.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0 || event.getClass() != clazz) {
                    return;
                }
                try {
                    Entity entity = (Entity)getEntity.invoke((Object)event, new Object[0]);
                    if (!(entity instanceof NPCHolder)) {
                        return;
                    }
                    NPC npc = ((NPCHolder)entity).getNPC();
                    Entity pushedBy = (Entity)getPushedBy.invoke((Object)event, new Object[0]);
                    Vector vector = (Vector)getAcceleration.invoke((Object)event, new Object[0]);
                    NPCPushEvent push = new NPCPushEvent(npc, vector, pushedBy);
                    if (pushedBy == null && !npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!npc.isProtected())).booleanValue()) {
                        push.setCancelled(true);
                    }
                    Bukkit.getPluginManager().callEvent((Event)push);
                    ((Cancellable)event).setCancelled(push.isCancelled());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }, EventPriority.NORMAL, (Plugin)this.plugin, true));
        }
        catch (Throwable ex) {
            Messaging.severe("Error registering push event forwarder");
            ex.printStackTrace();
        }
    }

    private void respawnAllFromCoord(ChunkCoord coord, Event event) {
        ArrayList ids = Lists.newArrayList((Iterable)this.toRespawn.get((Object)coord));
        if (ids.size() > 0) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Respawning all NPCs at", (Object)coord, new Object[]{"due to", event, "at", coord}));
        }
        for (int i = 0; i < ids.size(); ++i) {
            NPC npc = (NPC)ids.get(i);
            if (npc.getOwningRegistry().getById(npc.getId()) != npc) {
                Messaging.idebug(() -> "Prevented deregistered NPC from respawning " + npc);
                continue;
            }
            if (npc.isSpawned()) {
                Messaging.idebug(() -> "Can't respawn NPC " + npc + ": already spawned");
                continue;
            }
            boolean success = this.spawn(npc);
            if (!success) {
                ids.remove(i--);
                Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Couldn't respawn", (Object)npc, new Object[]{"during", event, "at", coord}));
                continue;
            }
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Spawned", (Object)npc, new Object[]{"during", event, "at", coord}));
        }
        for (NPC npc : ids) {
            this.toRespawn.remove((Object)coord, (Object)npc);
        }
    }

    private boolean spawn(NPC npc) {
        Location spawn = npc.getOrAddTrait(CurrentLocation.class).getLocation();
        if (spawn == null) {
            Messaging.idebug(() -> "Couldn't find a spawn location for despawned NPC " + npc);
            return false;
        }
        return npc.spawn(spawn, SpawnReason.CHUNK_LOAD);
    }

    private void unloadNPCs(ChunkEvent event, List<NPC> toDespawn) {
        ChunkCoord coord = new ChunkCoord(event.getChunk());
        boolean loadChunk = false;
        if (toDespawn.size() > 0) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Despawning all NPCs at", (Object)coord, new Object[]{"due to", event, "at", coord}));
        }
        for (NPC npc : toDespawn) {
            if (this.toRespawn.containsValue((Object)npc)) continue;
            if (!npc.despawn(DespawnReason.CHUNK_UNLOAD)) {
                if (!(event instanceof Cancellable)) {
                    Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Reloading chunk because", (Object)npc, new Object[]{"couldn't despawn"}));
                    loadChunk = true;
                    this.toRespawn.put((Object)coord, (Object)npc);
                    continue;
                }
                ((Cancellable)event).setCancelled(true);
                Messaging.idebug(() -> "Cancelled chunk unload at " + coord);
                this.respawnAllFromCoord(coord, (Event)event);
                return;
            }
            this.toRespawn.put((Object)coord, (Object)npc);
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Despawned", (Object)npc, new Object[]{"due to chunk unload at", coord}));
        }
        if (loadChunk) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Loading chunk in 10 ticks due to forced chunk load at", (Object)coord, new Object[0]));
            Chunk chunk = event.getChunk();
            CitizensAPI.getScheduler().runRegionTaskLater(chunk.getWorld(), chunk.getX(), chunk.getZ(), () -> {
                if (!event.getChunk().isLoaded()) {
                    event.getChunk().load();
                }
            }, 10L);
        }
    }

    private static void talkToBystanders(NPC npc, String text, SpeechContext context) {
        List bystanderEntities = npc.getEntity().getNearbyEntities(Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble());
        for (Entity bystander : bystanderEntities) {
            boolean shouldTalk = true;
            if (!Settings.Setting.TALK_CLOSE_TO_NPCS.asBoolean() && CitizensAPI.getNPCRegistry().isNPC(bystander)) {
                shouldTalk = false;
            }
            if (context.hasRecipients()) {
                for (Talkable target : context) {
                    if (!target.getEntity().equals((Object)bystander)) continue;
                    shouldTalk = false;
                    break;
                }
            }
            if (!shouldTalk) continue;
            new TalkableEntity(bystander).talkNear(context, text);
        }
    }
}

