/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class TargetNearbyEntityGoal
implements Behavior {
    private final boolean aggressive;
    private final Function<Entity, Boolean> filter;
    private boolean finished;
    private final NPC npc;
    private final double radius;
    private CancelReason reason;
    private Entity target;

    private TargetNearbyEntityGoal(NPC npc, boolean aggressive, double radius, Function<Entity, Boolean> filter) {
        this.npc = npc;
        this.filter = filter;
        this.aggressive = aggressive;
        this.radius = radius;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.target = null;
        this.finished = false;
        this.reason = null;
    }

    @Override
    public BehaviorStatus run() {
        if (this.finished) {
            return this.reason == null ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.npc.isSpawned()) {
            return false;
        }
        List nearby = this.npc.getEntity().getNearbyEntities(this.radius, this.radius, this.radius);
        this.target = null;
        Location npcLoc = this.npc.getEntity().getLocation();
        Location cache = new Location(null, 0.0, 0.0, 0.0);
        nearby.sort((a, b) -> Double.compare(a.getLocation(cache).distanceSquared(npcLoc), b.getLocation(cache).distanceSquared(npcLoc)));
        for (Entity entity : nearby) {
            if (!this.filter.apply(entity).booleanValue()) continue;
            this.target = entity;
            break;
        }
        if (this.target != null) {
            this.npc.getNavigator().setTarget(this.target, this.aggressive);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                this.reason = cancelReason;
                this.finished = true;
            });
            return true;
        }
        return false;
    }

    public static Builder builder(NPC npc) {
        return new Builder(npc);
    }

    public static class Builder {
        private boolean aggressive;
        private Function<Entity, Boolean> filter = e -> false;
        private final NPC npc;
        private double radius = 10.0;

        public Builder(NPC npc) {
            this.npc = npc;
        }

        public Builder aggressive(boolean aggressive) {
            this.aggressive = aggressive;
            return this;
        }

        public TargetNearbyEntityGoal build() {
            return new TargetNearbyEntityGoal(this.npc, this.aggressive, this.radius, this.filter);
        }

        public Builder radius(double radius) {
            this.radius = radius;
            return this;
        }

        public Builder targetFilter(Function<Entity, Boolean> filter) {
            this.filter = filter;
            return this;
        }

        public Builder targets(Set<EntityType> targetTypes) {
            this.filter = e -> targetTypes.contains(e.getType());
            return this;
        }
    }
}

