/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.speech;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.TalkableEntity;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;

public class SpeechContext
implements Iterable<Talkable> {
    private String message;
    private List<Talkable> recipients = Collections.emptyList();
    private Talkable talker = null;

    public SpeechContext(NPC talker, String message) {
        if (talker != null) {
            this.setTalker(talker.getEntity());
        }
        this.message = message;
    }

    public SpeechContext(NPC talker, String message, Entity recipient) {
        this(talker, message);
        if (recipient != null) {
            this.addRecipient(recipient);
        }
    }

    public SpeechContext(String message) {
        this.message = message;
    }

    public SpeechContext(String message, Entity recipient) {
        this.message = message;
        if (recipient != null) {
            this.addRecipient(recipient);
        }
    }

    public SpeechContext addRecipient(Entity entity) {
        if (this.recipients.isEmpty()) {
            this.recipients = new ArrayList<Talkable>();
        }
        this.recipients.add(new TalkableEntity(entity));
        return this;
    }

    public SpeechContext addRecipients(List<Talkable> talkables) {
        if (this.recipients.isEmpty()) {
            this.recipients = new ArrayList<Talkable>();
        }
        this.recipients.addAll(talkables);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Talkable getTalker() {
        return this.talker;
    }

    public boolean hasRecipients() {
        return !this.recipients.isEmpty();
    }

    @Override
    public Iterator<Talkable> iterator() {
        Iterator<Talkable> itr = this.recipients.iterator();
        return itr;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTalker(Entity entity) {
        this.talker = new TalkableEntity(entity);
    }

    public int size() {
        return this.recipients.size();
    }
}

