/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public abstract class Composite
implements Behavior {
    private final List<Behavior> behaviors;
    private final List<Behavior> parallel = Lists.newArrayListWithCapacity((int)0);
    protected final List<Behavior> parallelExecuting = Lists.newArrayListWithCapacity((int)0);

    public Composite(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    public Composite(Collection<Behavior> behaviors) {
        this.behaviors = Lists.newArrayList(behaviors);
        Iterator<Behavior> itr = this.behaviors.iterator();
        while (itr.hasNext()) {
            Behavior b = itr.next();
            if (!(b instanceof ParallelBehavior)) continue;
            this.parallel.add(b);
            itr.remove();
        }
    }

    public void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    @Override
    public void reset() {
        if (this.parallelExecuting.size() > 0) {
            for (Behavior behavior : this.parallelExecuting) {
                this.stopExecution(behavior);
            }
            this.parallelExecuting.clear();
        }
    }

    @Override
    public boolean shouldExecute() {
        return this.behaviors.size() > 0;
    }

    protected void stopExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        behavior.reset();
    }

    protected void tickParallel() {
        for (Behavior b : this.parallel) {
            this.tryAddParallel(b);
        }
        Iterator<Behavior> itr = this.parallelExecuting.iterator();
        while (itr.hasNext()) {
            Behavior behavior = itr.next();
            BehaviorStatus status = behavior.run();
            switch (status) {
                case RESET_AND_REMOVE: {
                    this.behaviors.remove(behavior);
                }
                case FAILURE: 
                case SUCCESS: {
                    itr.remove();
                    this.stopExecution(behavior);
                    break;
                }
            }
        }
    }

    private void tryAddParallel(Behavior behavior) {
        if (behavior.shouldExecute() && !this.parallelExecuting.contains(behavior)) {
            this.parallelExecuting.add(behavior);
        }
    }
}

