/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.NPCTraitCommandAttachEvent;
import net.citizensnpcs.api.event.NPCTraitCommandDetachEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

@Requirements(selected=true, ownership=true)
public class TraitCommands {
    private final Citizens plugin;

    public TraitCommands(Citizens plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"trait"}, usage="add [trait name]...", desc="", modifiers={"add", "a"}, min=2, permission="citizens.npc.trait")
    public void add(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(1))) {
            if (!sender.hasPermission("citizens.npc.trait." + traitName) && !sender.hasPermission("citizens.npc.trait.*")) {
                failed.add(String.format("%s: No permission", traitName));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName);
            if (clazz == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            if (npc.hasTrait(clazz)) {
                failed.add(String.format("%s: Already added", traitName));
                continue;
            }
            this.addTrait(npc, clazz, sender);
            added.add(StringHelper.wrap(traitName));
        }
        if (added.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.added", Joiner.on((String)", ").join(added));
        }
        if (failed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.failed-to-add", Joiner.on((String)", ").join(failed));
        }
    }

    private void addTrait(NPC npc, Class<? extends Trait> clazz, CommandSender sender) {
        npc.addTrait(clazz);
        Bukkit.getPluginManager().callEvent((Event)new NPCTraitCommandAttachEvent(npc, clazz, sender));
    }

    @Command(aliases={"trait"}, usage="clearsaves [trait name]", desc="", modifiers={"clearsaves"}, min=2, permission="citizens.npc.trait.clearsaves")
    public void clearsaves(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        List<String> added = Splitter.on((char)',').splitToStream((CharSequence)args.getJoinedStrings(1)).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        this.plugin.getDefaultNPCDataStore().clearTraitData(added);
        Messaging.sendTr(sender, "citizens.commands.trait.clearsaves.cleared", Joiner.on((String)", ").join(added));
    }

    @Command(aliases={"trait"}, usage="remove [trait names]...", desc="", modifiers={"remove", "rem", "r"}, min=2, permission="citizens.npc.trait")
    public void remove(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(1))) {
            if (!sender.hasPermission("citizens.npc.trait." + traitName) && !sender.hasPermission("citizens.npc.trait.*")) {
                failed.add(String.format("%s: No permission", traitName));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName);
            if (clazz == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            boolean hasTrait = npc.hasTrait(clazz);
            if (!hasTrait) {
                failed.add(String.format("%s: Trait not attached", traitName));
                continue;
            }
            this.removeTrait(npc, clazz, sender);
            removed.add(StringHelper.wrap(traitName));
        }
        if (removed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.removed", Joiner.on((String)", ").join(removed));
        }
        if (failed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.failed-to-remove", Joiner.on((String)", ").join(failed));
        }
    }

    private void removeTrait(NPC npc, Class<? extends Trait> clazz, CommandSender sender) {
        Bukkit.getPluginManager().callEvent((Event)new NPCTraitCommandDetachEvent(npc, clazz, sender));
        npc.removeTrait(clazz);
    }

    @Command(aliases={"trait"}, usage="[trait name], [trait name]...", desc="", modifiers={"*"}, min=1, permission="citizens.npc.trait")
    public void toggle(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(0))) {
            if (!sender.hasPermission("citizens.npc.trait." + traitName) && !sender.hasPermission("citizens.npc.trait.*")) {
                failed.add(String.format("%s: No permission", traitName));
                continue;
            }
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName);
            if (clazz == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            boolean remove = npc.hasTrait(clazz);
            if (remove) {
                this.removeTrait(npc, clazz, sender);
                removed.add(StringHelper.wrap(traitName));
                continue;
            }
            this.addTrait(npc, clazz, sender);
            added.add(StringHelper.wrap(traitName));
        }
        if (added.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.added", Joiner.on((String)", ").join(added));
        }
        if (removed.size() > 0) {
            Messaging.sendTr(sender, "citizens.commands.trait.removed", Joiner.on((String)", ").join(removed));
        }
        if (failed.size() > 0) {
            Messaging.send(sender, "Failed to toggle traits", Joiner.on((String)", ").join(failed));
        }
    }
}

