/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCCreateEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.RemoveReason;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.LookClose;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CitizensNPCRegistry
implements NPCRegistry {
    private final String name;
    private final Int2ObjectOpenHashMap<NPC> npcs = new Int2ObjectOpenHashMap();
    private final CitizensPlugin plugin;
    private final NPCDataStore saves;
    private final Map<UUID, NPC> uniqueNPCs = Maps.newConcurrentMap();

    public CitizensNPCRegistry(NPCDataStore store, CitizensPlugin plugin) {
        this(store, plugin, "");
    }

    public CitizensNPCRegistry(NPCDataStore store, CitizensPlugin cplugin, String registryName) {
        this.saves = store;
        this.plugin = cplugin;
        this.name = registryName;
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, UUID.randomUUID(), this.generateIntegerId(), name);
    }

    @Override
    public NPC createNPC(EntityType type, String name, Location loc) {
        NPC npc = this.createNPC(type, name);
        npc.spawn(loc, SpawnReason.PLUGIN);
        return npc;
    }

    @Override
    public NPC createNPC(EntityType type, UUID uuid, int id, String name) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        CitizensNPC npc = new CitizensNPC(uuid, id, name, EntityControllers.createForType(type), this, this.plugin);
        npc.getOrAddTrait(MobType.class).setType(type);
        this.npcs.put(id, (Object)npc);
        this.uniqueNPCs.put(npc.getUniqueId(), npc);
        Bukkit.getPluginManager().callEvent((Event)new NPCCreateEvent(npc));
        if (type == EntityType.ARMOR_STAND && !npc.hasTrait(ArmorStandTrait.class)) {
            npc.addTrait(ArmorStandTrait.class);
        }
        if (Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean()) {
            npc.addTrait(LookClose.class);
        }
        return npc;
    }

    @Override
    public NPC createNPCUsingItem(EntityType type, String name, ItemStack item) {
        NPC npc = this.createNPC(type, name);
        if (!(type.name().equals("OMINOUS_ITEM_SPAWNER") || type.name().equals("DROPPED_ITEM") || type.name().contains("MINECART") || type.name().equals("ITEM") || type == EntityType.FALLING_BLOCK || type == EntityType.ITEM_FRAME || type.name().equals("GLOW_ITEM_FRAME") || type.name().equals("ITEM_DISPLAY") || type.name().equals("BLOCK_DISPLAY"))) {
            throw new UnsupportedOperationException("Not an item entity type");
        }
        npc.data().set(NPC.Metadata.ITEM_AMOUNT, (Object)item.getAmount());
        npc.data().set(NPC.Metadata.ITEM_ID, (Object)item.getType().name());
        npc.data().set(NPC.Metadata.ITEM_DATA, (Object)item.getData().getData());
        npc.setItemProvider(() -> item.clone());
        return npc;
    }

    @Override
    public void deregister(NPC npc) {
        npc.despawn(DespawnReason.REMOVAL);
        this.npcs.remove(npc.getId());
        this.uniqueNPCs.remove(npc.getUniqueId());
        if (this.saves != null) {
            this.saves.clearData(npc);
        }
    }

    @Override
    public void deregisterAll() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            npc.despawn(DespawnReason.REMOVAL);
            for (Trait t : npc.getTraits()) {
                HandlerList.unregisterAll((Listener)t);
                t.onRemove(RemoveReason.REMOVAL);
            }
            itr.remove();
            if (this.saves == null) continue;
            this.saves.clearData(npc);
        }
    }

    @Override
    public void despawnNPCs(DespawnReason reason) {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            try {
                npc.despawn(reason);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            itr.remove();
        }
    }

    private int generateIntegerId() {
        return this.saves.createUniqueNPCId(this);
    }

    @Override
    public NPC getById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("invalid id");
        }
        return (NPC)this.npcs.get(id);
    }

    @Override
    public NPC getByUniqueId(UUID uuid) {
        if (uuid.version() == 2) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFDFFFL;
            uuid = new UUID(msb |= 0x4000L, uuid.getLeastSignificantBits());
        }
        return this.uniqueNPCs.get(uuid);
    }

    @Override
    public NPC getByUniqueIdGlobal(UUID uuid) {
        NPC npc;
        if (uuid.version() == 2) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFDFFFL;
            uuid = new UUID(msb |= 0x4000L, uuid.getLeastSignificantBits());
        }
        if ((npc = this.getByUniqueId(uuid)) != null) {
            return npc;
        }
        for (NPCRegistry registry : CitizensAPI.getNPCRegistries()) {
            NPC other;
            if (registry == this || (other = registry.getByUniqueId(uuid)) == null) continue;
            return other;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NPC getNPC(Entity entity) {
        return entity instanceof NPCHolder ? ((NPCHolder)entity).getNPC() : null;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return new Iterator<NPC>(){
            Iterator<NPC> itr;
            UUID lastUUID;
            {
                this.itr = CitizensNPCRegistry.this.npcs.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public NPC next() {
                NPC npc = this.itr.next();
                if (npc != null && npc.getUniqueId() != null) {
                    this.lastUUID = npc.getUniqueId();
                }
                return npc;
            }

            @Override
            public void remove() {
                this.itr.remove();
                if (this.lastUUID != null) {
                    CitizensNPCRegistry.this.uniqueNPCs.remove(this.lastUUID);
                    this.lastUUID = null;
                }
            }
        };
    }

    @Override
    public void saveToStore() {
        this.saves.storeAll(this);
        this.saves.saveToDiskImmediate();
    }

    @Override
    public Iterable<NPC> sorted() {
        ArrayList<NPC> vals = new ArrayList<NPC>((Collection<NPC>)this.npcs.values());
        vals.sort(Comparator.comparing(NPC::getId));
        return vals;
    }
}

