/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Interaction;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

@TraitName(value="boundingbox")
public class BoundingBoxTrait
extends Trait
implements Supplier<BoundingBox> {
    private EntityDim base;
    private Function<EntityDim, BoundingBox> function;
    @Persist
    private float height = -1.0f;
    private NPC interaction;
    @Persist
    private Vector offset = ZERO;
    @Persist
    private float scale = -1.0f;
    @Persist
    private float width = -1.0f;
    private static boolean SUPPORTS_INTERACTION = true;
    private static boolean SUPPORTS_RESPONSIVE = true;
    private static final Vector ZERO = new Vector(0, 0, 0);

    public BoundingBoxTrait() {
        super("boundingbox");
    }

    @Override
    public BoundingBox get() {
        Location location = this.npc.getEntity().getLocation();
        if (this.function != null) {
            BoundingBox bb = this.function.apply(this.getAdjustedDimensions());
            NMS.setDimensions(this.npc.getEntity(), bb.toDimensions());
            return bb.add(location);
        }
        EntityDim dim = this.getAdjustedDimensions();
        NMS.setDimensions(this.npc.getEntity(), dim);
        return new BoundingBox(location.getX() - (double)(dim.width / 2.0f) + this.offset.getX(), location.getY() + this.offset.getY(), location.getZ() - (double)(dim.width / 2.0f) + this.offset.getZ(), location.getX() + (double)(dim.width / 2.0f) + this.offset.getX(), location.getY() + (double)dim.height + this.offset.getY(), location.getZ() + (double)(dim.width / 2.0f) + this.offset.getZ());
    }

    public EntityDim getAdjustedDimensions() {
        EntityDim desired = this.base;
        if (this.scale != -1.0f) {
            desired = desired.mul(this.scale);
        }
        return new EntityDim(this.width == -1.0f ? desired.width : this.width, this.height == -1.0f ? desired.height : this.height);
    }

    private Location getBaseLocation(Entity entity) {
        Location loc = entity.getLocation();
        String entityType = entity.getType().toString();
        if (entityType.equals("ITEM_DISPLAY")) {
            loc.add(0.0, -0.5, 0.0);
        } else if (entityType.equals("BLOCK_DISPLAY")) {
            loc.add(0.5, 0.0, 0.5);
        }
        return loc;
    }

    @Override
    public void onDespawn() {
        this.npc.data().remove(NPC.Metadata.BOUNDING_BOX_FUNCTION);
        if (this.interaction != null) {
            this.interaction.destroy();
            this.interaction = null;
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        if (this.npc.getEntity().getType().toString().equals("BLOCK_DISPLAY")) {
            BoundingBox bb = NMS.getCollisionBox(((BlockDisplay)this.npc.getEntity()).getBlock());
            this.base = EntityDim.from(bb);
        } else if (this.npc.getEntity().getType() == EntityType.FALLING_BLOCK) {
            BoundingBox bb = NMS.getCollisionBox(((FallingBlock)this.npc.getEntity()).getBlockData());
            this.base = EntityDim.from(bb);
        } else {
            this.base = this.npc.getEntity().getType().toString().equals("ITEM_DISPLAY") ? EntityDim.from(new BoundingBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)) : EntityDim.from(this.npc.getEntity());
        }
        this.npc.data().set(NPC.Metadata.BOUNDING_BOX_FUNCTION, (Object)this);
        if (!SUPPORTS_INTERACTION) {
            return;
        }
        this.interaction = CitizensAPI.getTemporaryNPCRegistry().createNPC(EntityType.INTERACTION, "");
        this.interaction.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
        this.interaction.addTrait(new ClickRedirectTrait(this.npc));
        this.interaction.spawn(this.npc.getStoredLocation());
        if (SUPPORTS_RESPONSIVE) {
            ((Interaction)this.interaction.getEntity()).setResponsive(true);
        }
    }

    @Override
    public void run() {
        if (this.interaction == null) {
            return;
        }
        if (!this.interaction.isSpawned()) {
            this.interaction.spawn(this.getBaseLocation(this.npc.getEntity()));
            return;
        }
        EntityDim dim = this.getAdjustedDimensions();
        this.interaction.teleport(this.getBaseLocation(this.npc.getEntity()), PlayerTeleportEvent.TeleportCause.PLUGIN);
        Interaction box = (Interaction)this.interaction.getEntity();
        box.setInteractionWidth(dim.width);
        box.setInteractionHeight(dim.height);
    }

    public void setBoundingBoxFunction(Function<EntityDim, BoundingBox> func) {
        this.function = func;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.bukkit.entity.Interaction");
            try {
                clazz.getMethod("isResponsive", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                SUPPORTS_RESPONSIVE = false;
            }
        }
        catch (ClassNotFoundException e) {
            SUPPORTS_INTERACTION = false;
        }
    }
}

