/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;

@TraitName(value="llamatrait")
public class LlamaTrait
extends Trait {
    @Persist
    private Llama.Color color = Llama.Color.BROWN;
    @Persist
    private int strength = 3;

    public LlamaTrait() {
        super("llamatrait");
    }

    public Llama.Color getColor() {
        return this.color;
    }

    public int getStrength() {
        return this.strength;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getCosmeticEntity() instanceof Llama) {
            Llama llama = (Llama)this.npc.getCosmeticEntity();
            llama.setColor(this.color);
            llama.setStrength(this.strength);
        }
    }

    public void setColor(Llama.Color color) {
        this.color = color;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    @Command(aliases={"npc"}, usage="llama (--color color) (--strength strength)", desc="", modifiers={"llama"}, min=1, max=1, permission="citizens.npc.llama")
    @Requirements(selected=true, ownership=true)
    public static void llama(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color", "colour"}) Llama.Color color, @Flag(value={"strength"}) Integer strength) throws CommandException {
        EntityType type = npc.getCosmeticEntityType();
        if (!type.name().contains("LLAMA")) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type));
        }
        LlamaTrait trait = npc.getOrAddTrait(LlamaTrait.class);
        String output = "";
        if (args.hasAnyValueFlag("color", "colour")) {
            if (color == null) {
                String valid = Util.listValuesPretty(Llama.Color.values());
                throw new CommandException("citizens.commands.npc.llama.invalid-color", valid);
            }
            trait.setColor(color);
            output = output + Messaging.tr("citizens.commands.npc.llama.color-set", Util.prettyEnum(color));
        }
        if (strength != null) {
            trait.setStrength(Math.max(1, Math.min(5, strength)));
            output = output + Messaging.tr("citizens.commands.npc.llama.strength-set", trait.getStrength());
        }
        if (args.hasFlag('c')) {
            npc.getOrAddTrait(HorseModifiers.class).setCarryingChest(true);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (args.hasFlag('b')) {
            npc.getOrAddTrait(HorseModifiers.class).setCarryingChest(false);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

