/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftSkeletonHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SkeletonHorse;

public class HorseSkeletonController
extends MobEntityController {
    public HorseSkeletonController() {
        super(EntityHorseSkeletonNPC.class);
    }

    public void create(Location at, NPC npc) {
        npc.getOrAddTrait(HorseModifiers.class);
        super.create(at, npc);
    }

    public SkeletonHorse getBukkitEntity() {
        return (SkeletonHorse)super.getBukkitEntity();
    }

    public static class EntityHorseSkeletonNPC
    extends EntityHorseSkeleton
    implements NPCHolder {
        private double baseMovementSpeed;
        private final CitizensNPC npc;
        private boolean riding;

        public EntityHorseSkeletonNPC(EntityTypes<? extends EntityHorseSkeleton> types, World level) {
            this(types, level, null);
        }

        public EntityHorseSkeletonNPC(EntityTypes<? extends EntityHorseSkeleton> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                ((SkeletonHorse)this.getBukkitEntity()).setDomestication(((SkeletonHorse)this.getBukkitEntity()).getMaxDomestication());
                this.baseMovementSpeed = this.f(GenericAttributes.r).f();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean o(bsw entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(float f, float f1, brp damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dB() {
            if (this.npc == null) {
                super.dB();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void Z() {
            super.Z();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                if (this.npc.hasTrait(Controllable.class) && ((Controllable)this.npc.getOrAddTrait(Controllable.class)).isEnabled()) {
                    this.riding = this.getBukkitEntity().getPassengers().size() > 0;
                    this.f(GenericAttributes.r).a(this.baseMovementSpeed * (double)this.npc.getNavigator().getDefaultParameters().speedModifier());
                } else {
                    this.riding = false;
                }
                if (this.riding) {
                    if (this.npc.getNavigator().isNavigating()) {
                        CraftEntity basePassenger = ((bsw)this.p.get(0)).getBukkitEntity();
                        NMS.look((Entity)basePassenger, (float)this.dF(), (float)this.dH());
                    }
                    this.d(4, true);
                }
                NMS.setStepHeight((Entity)this.getBukkitEntity(), (float)1.0f);
                this.npc.update();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((bsw)this, (CraftEntity)new HorseSkeletonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(brp damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
        }

        public int cx() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cx());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean da() {
            if (this.npc != null && this.riding) {
                return true;
            }
            return super.da();
        }

        public boolean gd() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.gd(), (EntityInsentient)this);
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public boolean bS() {
            return this.npc != null && this.npc.getNavigator().isNavigating() ? false : super.bS();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.as());
        }

        public boolean q_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.q_();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(bsw entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public bsw teleportTo(WorldServer worldserver, Vec3D location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((bsw)this, worldserver, location);
        }

        public void a(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(axf<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.ds().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.h(old);
            }
            return res;
        }
    }

    public static class HorseSkeletonNPC
    extends CraftSkeletonHorse
    implements ForwardingNPCHolder {
        public HorseSkeletonNPC(EntityHorseSkeletonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityHorseSkeleton)entity);
        }
    }
}

