/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R6.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R6.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R6.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R6.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R6.util.MobAI;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private AdvancementDataPlayer advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(PlayerInteractManager.class, (boolean)true, (Class[])new Class[]{EnumGamemode.class, EnumGamemode.class});

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, ClientInformation ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            try {
                GAMEMODE_SETTER.invoke(this.h, EnumGamemode.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public boolean a(EntityPlayer player) {
        return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
    }

    public boolean a(double f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(DamageSource damagesource) {
        if (this.bI) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            this.A().a((EntityPlayer)this, Entity.RemovalReason.a);
            this.A().n().a((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void h() {
        boolean navigating;
        if (this.npc == null) {
            super.h();
            return;
        }
        NMSImpl.callNPCMoveEvent((NPC)this.npc, (net.minecraft.world.entity.Entity)this);
        super.aH();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity() || !Util.isLoaded((Location)this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe((double)this.dM(), (World)this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.c);
        }
        Vec3D mot = this.dI();
        if (Math.abs(mot.g) < (double)0.003f && Math.abs(mot.h) < (double)0.003f && Math.abs(mot.i) < (double)0.003f) {
            this.k(Vec3D.c);
        }
        if (navigating) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().d();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aT();
        this.ar = this.at();
        if (this.at()) {
            this.bc = false;
        }
        this.q();
        if (this.npc.useMinecraftAI()) {
            this.cm.a((EntityPlayer)this);
        }
        if (((Boolean)this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, (Object)false)).booleanValue()) {
            if (this.cp > 0) {
                --this.cp;
            }
            AxisAlignedBB axisalignedbb = this.cl() && !this.du().ec() ? this.de().b(this.du().de()).c(1.0, 0.0, 1.0) : this.de().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.A().a_((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.a_((EntityHuman)this);
            }
        }
        ++this.by;
        this.gW().a();
        EntityPoseTrait ept = (EntityPoseTrait)this.npc.getTraitNullable(EntityPoseTrait.class);
        if (ept == null || ept.getPose() == null) {
            this.gt();
        }
    }

    public AdvancementDataPlayer U() {
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cK.aE(), this.cK.am(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect f_() {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect e(DamageSource damagesource) {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fw() {
        return NMS.getJumpPower((NPC)this.npc, (float)super.fw());
    }

    public int cR() {
        return NMS.getFallDistance((NPC)this.npc, (int)super.cR());
    }

    public NPC getNPC() {
        return this.npc;
    }

    public EnumPistonReaction p_() {
        return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
    }

    public GameProfile getProfile() {
        return super.gz();
    }

    public String getSkinName() {
        String skinName = ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager K() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent Q() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((ComponentContents)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage((String)this.npc.getRawName()) : super.Q();
    }

    public boolean a(WorldServer level, DamageSource damagesource, float f) {
        boolean damaged = super.a(level, damagesource, f);
        if (damaged && this.ah) {
            this.ah = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.ah = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(EnumProtocolDirection.b);
            this.g = new EmptyPacketListener(minecraftServer, conn, this, CommonListenerCookie.a((GameProfile)this.getProfile(), (boolean)false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.w(true);
        this.setSkinFlags((byte)-1);
    }

    public boolean bY() {
        if (this.npc == null || this.ar || this.gg()) {
            return super.bY();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bU() {
        return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
    }

    public void o(double strength, double dx, double dz) {
        NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bL) {
            if (this.bc && this.jumpTicks == 0) {
                this.u();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bM *= 0.98f;
        this.bO *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bM, (double)this.bN, (double)this.bO));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), (float)this.dX());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double x = this.dK();
        double y = this.dM();
        double z = this.dQ();
        this.m(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dK() - x, this.dM() - y, this.dQ() - z, this.bc);
        }
    }

    public boolean fe() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.fe();
        }
        return false;
    }

    public void h(net.minecraft.world.entity.Entity entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.U().b();
    }

    public void setSkinFlags(byte flags) {
        this.aC().a(EntityHuman.t, (Object)flags);
    }

    public void setSkinName(String name) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name);
    }

    public void setSkinName(String name, boolean forceUpdate) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name, forceUpdate);
    }

    public void setSkinPersistent(String skinName, String signature, String data) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinPersistent(skinName, signature, data);
    }

    public void g() {
        super.g();
        if (this.npc == null) {
            return;
        }
        if (NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES != null) {
            try {
                NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES.invoke(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.detectEquipmentUpdatesPublic();
        }
        this.c(List.of());
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.fO()) {
            if (ItemStack.b((ItemStack)this.b(this.fP()), (ItemStack)this.bS)) {
                this.bS = this.b(this.fP());
                this.a(this.bS);
            } else {
                this.fU();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void m(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.m(vec3d);
        } else {
            NMSImpl.moveLogic((EntityLiving)this, vec3d);
        }
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        Vec3D old = this.dI().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.k(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.co = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

