/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Player;

public interface EntityPacketTracker
extends Runnable {
    public void link(Player var1);

    public void unlink(Player var1);

    public void unlinkAll(Consumer<Player> var1);

    public static class PacketAggregator {
        private final Set<PlayerConnection> connections = Sets.newHashSet();
        private List<Object> packets;

        public void add(UUID uuid, Consumer<Object> conn) {
            this.connections.add(new PlayerConnection(uuid, conn));
        }

        public void removeConnection(UUID uuid) {
            this.connections.remove(new PlayerConnection(uuid, null));
        }

        public void send(Object packet) {
            if (this.packets != null) {
                this.packets.add(packet);
                return;
            }
            for (PlayerConnection conn : this.connections) {
                conn.conn.accept(packet);
            }
        }

        public void send(Object packet, List<UUID> ignoring) {
            for (PlayerConnection conn : this.connections) {
                if (ignoring.contains(conn.uuid)) continue;
                conn.conn.accept(packet);
            }
        }

        public void startBundling() {
            this.packets = Lists.newArrayList();
        }

        public void stopBundlingAndSend() {
            Iterable<Object> packets = NMS.createBundlePacket(this.packets);
            this.packets = null;
            for (Object packet : packets) {
                for (PlayerConnection conn : this.connections) {
                    conn.conn.accept(packet);
                }
            }
        }

        private static class PlayerConnection {
            Consumer<Object> conn;
            UUID uuid;

            public PlayerConnection(UUID uuid, Consumer<Object> conn) {
                this.uuid = uuid;
                this.conn = conn;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                PlayerConnection other = (PlayerConnection)obj;
                return Objects.equals(this.uuid, other.uuid);
            }

            public int hashCode() {
                return 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
            }
        }
    }
}

