/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationPersister
implements Persister<Location> {
    @Override
    public Location create(DataKey root) {
        String worldName;
        World world;
        if (!root.keyExists("world") && !root.keyExists("worldid")) {
            return null;
        }
        UUID worldUUID = null;
        if (root.keyExists("world")) {
            world = Bukkit.getWorld((String)root.getString("world"));
            worldName = root.getString("world");
            root.removeKey("world");
        } else {
            worldName = null;
            worldUUID = UUID.fromString(root.getString("worldid"));
            world = Bukkit.getWorld((UUID)worldUUID);
        }
        double x = root.getDouble("x");
        double y = root.getDouble("y");
        double z = root.getDouble("z");
        float yaw = this.normalise(root.getDouble("yaw"));
        float pitch = this.normalise(root.getDouble("pitch"));
        return world == null ? new LazilyLoadedLocation(worldUUID, worldName, x, y, z, yaw, pitch) : new Location(world, x, y, z, yaw, pitch);
    }

    private float normalise(double d) {
        if (Double.isNaN(d)) {
            return 0.0f;
        }
        return (float)(!Double.isFinite(d) ? 0.0 : d);
    }

    private double round(double z) {
        if (Double.isInfinite(z) || Double.isNaN(z)) {
            return 0.0;
        }
        return new BigDecimal(z).setScale(4, RoundingMode.HALF_DOWN).doubleValue();
    }

    @Override
    public void save(Location location, DataKey root) {
        if (location.getWorld() != null) {
            root.setString("worldid", location.getWorld().getUID().toString());
        }
        root.setDouble("x", this.round(location.getX()));
        root.setDouble("y", this.round(location.getY()));
        root.setDouble("z", this.round(location.getZ()));
        root.setDouble("yaw", this.round(location.getYaw()));
        root.setDouble("pitch", this.round(location.getPitch()));
    }

    public static class LazilyLoadedLocation
    extends Location {
        private UUID worldID;
        private final String worldName;

        public LazilyLoadedLocation(UUID world, String worldName, double x, double y, double z, float yaw, float pitch) {
            super(null, x, y, z, yaw, pitch);
            this.worldID = world;
            this.worldName = worldName;
        }

        public World getWorld() {
            if (super.getWorld() == null) {
                super.setWorld(this.worldName != null ? Bukkit.getWorld((String)this.worldName) : Bukkit.getWorld((UUID)this.worldID));
                if (this.worldID == null && super.getWorld() != null) {
                    this.worldID = super.getWorld().getUID();
                }
            }
            return super.getWorld();
        }

        public UUID getWorldUUID() {
            return this.worldID;
        }
    }
}

