/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import java.util.Objects;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.ForwardingBehaviorGoalAdapter;

public class SimpleGoalEntry
implements GoalController.GoalEntry {
    private final Goal goal;
    private final Supplier<Integer> priority;

    public SimpleGoalEntry(Goal goal, int priority) {
        this(goal, () -> priority);
    }

    public SimpleGoalEntry(Goal goal, Supplier<Integer> priority) {
        this.goal = goal;
        this.priority = priority;
    }

    @Override
    public int compareTo(GoalController.GoalEntry o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleGoalEntry other = (SimpleGoalEntry)obj;
        if (!Objects.equals(this.goal, other.goal)) {
            return false;
        }
        return this.priority == other.priority;
    }

    @Override
    public Behavior getBehavior() {
        return this.goal instanceof Behavior ? (Behavior)((Object)this.goal) : (this.goal instanceof ForwardingBehaviorGoalAdapter ? ((ForwardingBehaviorGoalAdapter)this.goal).getWrapped() : null);
    }

    @Override
    public Goal getGoal() {
        return this.goal;
    }

    @Override
    public int getPriority() {
        return this.priority.get();
    }

    public int hashCode() {
        int prime = 31;
        return 31 * (31 + (this.goal == null ? 0 : this.goal.hashCode())) + this.priority.get();
    }
}

