/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@TraitName(value="potioneffects")
public class PotionEffectsTrait
extends Trait {
    @Persist(valueType=PotionEffect.class)
    private final Map<String, PotionEffect> persistent = Maps.newHashMap();
    private final List<PotionEffect> temporary = Lists.newArrayList();

    public PotionEffectsTrait() {
        super("potioneffects");
    }

    public void addEffect(PotionEffect effect) {
        this.temporary.add(effect);
    }

    public void addPersistentEffect(String name, PotionEffect effect) {
        this.persistent.put(name, effect);
        if (this.npc.isSpawned() && this.npc.getEntity().getType().isAlive()) {
            ((LivingEntity)this.npc.getEntity()).addPotionEffect(effect);
        }
    }

    public Map<String, PotionEffect> getPersistentEffects() {
        return this.persistent;
    }

    @Override
    public void onSpawn() {
        if (!this.npc.getEntity().getType().isAlive()) {
            return;
        }
        LivingEntity entity = (LivingEntity)this.npc.getEntity();
        for (PotionEffect effect : this.persistent.values()) {
            entity.addPotionEffect(effect);
        }
    }

    public void removePersistentEffect(String name) {
        this.persistent.remove(name);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.npc.getEntity().getType().isAlive()) {
            return;
        }
        LivingEntity entity = (LivingEntity)this.npc.getEntity();
        for (PotionEffect effect : this.temporary) {
            entity.addPotionEffect(effect);
        }
        this.temporary.clear();
    }

    @Command(aliases={"npc"}, usage="potioneffect [add|remove|list] (--name [name] or -t for temporary) (--type [type]) (--duration [duration]) (--amplifier [amplifier]) (--icon [icon])", desc="", modifiers={"potioneffect"}, flags="it", min=2, max=2, permission="citizens.npc.potioneffect")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public static void potioneffect(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"add", "list", "remove"}) String operation, @Flag(value={"duration"}, defValue="-1") Integer duration, @Flag(value={"name"}) String name, @Flag(value={"amplifier"}, defValue="1") Integer amplifier, @Flag(value={"type"}) PotionEffectType type, @Flag(value={"icon"}, defValue="false") Boolean icon, @Flag(value={"ambient"}, defValue="false") Boolean ambient, @Flag(value={"particles"}, defValue="false") Boolean particles) throws CommandException {
        PotionEffectsTrait trait = npc.getOrAddTrait(PotionEffectsTrait.class);
        if (operation.equals("add")) {
            if (type == null) {
                throw new CommandUsageException();
            }
            if (name == null && !args.hasFlag('t')) {
                throw new CommandUsageException();
            }
            if (args.hasFlag('i')) {
                duration = -1;
            }
            PotionEffect effect = new PotionEffect(type, duration.intValue(), amplifier.intValue(), ambient.booleanValue(), particles.booleanValue(), icon.booleanValue());
            if (args.hasFlag('t')) {
                trait.addEffect(effect);
            } else {
                trait.addPersistentEffect(name, effect);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.potioneffects.effect-added", effect);
        } else if (operation.equals("list")) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, PotionEffect> entry : trait.getPersistentEffects().entrySet()) {
                builder.append("[[-]] " + entry.getKey() + ": " + entry.getValue());
            }
            Messaging.send(sender, builder.toString());
        } else {
            if (name == null) {
                throw new CommandUsageException();
            }
            trait.removePersistentEffect(name);
            Messaging.sendTr(sender, "citizens.commands.npc.potioneffects.effect-removed", name);
        }
    }
}

