/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTrigger;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.ChatTrigger;
import net.citizensnpcs.trait.waypoint.triggers.ChatTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.CommandTrigger;
import net.citizensnpcs.trait.waypoint.triggers.CommandTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.DelayTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTrigger;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTrigger;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.conversations.Prompt;

public class WaypointTriggerRegistry
implements Persister<WaypointTrigger> {
    private static final Map<String, Class<? extends Prompt>> TRIGGER_PROMPTS = Maps.newHashMap();
    private static final Map<String, Class<? extends WaypointTrigger>> TRIGGERS = Maps.newHashMap();

    @Override
    public WaypointTrigger create(DataKey root) {
        String type = root.getString("type");
        Class<? extends WaypointTrigger> clazz = TRIGGERS.get(type);
        return clazz == null ? null : (WaypointTrigger)((Object)PersistenceLoader.load(clazz, root));
    }

    @Override
    public void save(WaypointTrigger instance, DataKey root) {
        PersistenceLoader.save(instance, root);
        for (Map.Entry<String, Class<? extends WaypointTrigger>> entry : TRIGGERS.entrySet()) {
            if (entry.getValue() != instance.getClass()) continue;
            root.setString("type", entry.getKey());
            break;
        }
    }

    public static void addTrigger(String name, Class<? extends WaypointTrigger> triggerClass, Class<? extends WaypointTriggerPrompt> promptClass) {
        TRIGGERS.put(name, triggerClass);
        TRIGGER_PROMPTS.put(name, promptClass);
    }

    public static String describeValidTriggerNames() {
        return Joiner.on((String)", ").join(TRIGGER_PROMPTS.keySet());
    }

    public static Prompt getTriggerPromptFrom(String input) {
        Class<? extends Prompt> promptClass = TRIGGER_PROMPTS.get(input);
        if (promptClass == null) {
            return null;
        }
        try {
            return promptClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        WaypointTriggerRegistry.addTrigger("animation", AnimationTrigger.class, AnimationTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("command", CommandTrigger.class, CommandTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("chat", ChatTrigger.class, ChatTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("delay", DelayTrigger.class, DelayTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("teleport", TeleportTrigger.class, TeleportTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("speed", SpeedTrigger.class, SpeedTriggerPrompt.class);
    }
}

