/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.CurrentLocation;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CopierEditor
extends Editor {
    private final String name;
    private final NPC npc;
    private final Player player;

    public CopierEditor(Player player, NPC npc) {
        this.player = player;
        this.npc = npc;
        this.name = npc.getRawName();
    }

    @Override
    public void begin() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.copier.begin", new Object[0]);
    }

    @Override
    public void end() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.copier.end", new Object[0]);
    }

    @EventHandler
    public void onBlockClick(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || !event.getPlayer().equals((Object)this.player)) {
            return;
        }
        NPC copy = this.npc.clone();
        if (!copy.getRawName().equals(this.name)) {
            copy.setName(this.name);
        }
        if (copy.isSpawned() && this.player.isOnline()) {
            Location location = event.getClickedBlock().getLocation();
            location.setYaw(this.player.getLocation().getYaw());
            location.setPitch(this.player.getLocation().getPitch());
            location.getChunk().load();
            copy.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            copy.getOrAddTrait(CurrentLocation.class).setLocation(location);
        }
        Messaging.sendTr((CommandSender)this.player, "citizens.commands.npc.copy.copied", this.npc.getName());
        event.setCancelled(true);
    }
}

