/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.google.common.collect.Lists;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.expr.CompiledExpression;
import net.citizensnpcs.api.expr.ExpressionEngine;
import net.citizensnpcs.api.expr.ExpressionScope;

public class DenizenHook {
    private final Citizens plugin;

    public DenizenHook(Citizens plugin) {
        this.plugin = plugin;
        plugin.getExpressionRegistry().registerEngine(new DenizenEngine());
        plugin.getExpressionRegistry().setDefaultEngine("denizen");
    }

    public class DenizenEngine
    implements ExpressionEngine {
        @Override
        public CompiledExpression compile(String expression) throws ExpressionEngine.ExpressionCompileException {
            YamlConfiguration config = new YamlConfiguration();
            config.set("type", (Object)"task");
            config.set("script", (Object)Lists.newArrayList((Object[])new String[]{expression}));
            final TaskScriptContainer sc = new TaskScriptContainer(config, UUID.randomUUID().toString());
            return new CompiledExpression(){

                @Override
                public Object evaluate(ExpressionScope scope) {
                    ScriptQueue sq = sc.run(null, field -> {
                        switch (field) {
                            case "npc": {
                                return new NPCTag(scope.getNPC());
                            }
                            case "player": {
                                return new PlayerTag(scope.getPlayer());
                            }
                        }
                        Object value = scope.get(field);
                        if (value == null) {
                            return null;
                        }
                        if (value instanceof Byte) {
                            return new ElementTag(((Byte)value).byteValue());
                        }
                        if (value instanceof Integer) {
                            return new ElementTag(((Integer)value).intValue());
                        }
                        if (value instanceof Double) {
                            return new ElementTag(((Double)value).doubleValue());
                        }
                        if (value instanceof Character) {
                            return new ElementTag((int)((Character)value).charValue());
                        }
                        if (value instanceof String) {
                            return new ElementTag((String)value);
                        }
                        if (value instanceof Long) {
                            return new ElementTag(((Long)value).longValue());
                        }
                        if (value instanceof Enum) {
                            return new ElementTag((Enum)value);
                        }
                        if (value instanceof Float) {
                            return new ElementTag(((Float)value).floatValue());
                        }
                        if (value instanceof Boolean) {
                            return new ElementTag(((Boolean)value).booleanValue());
                        }
                        return new JavaReflectedObjectTag(scope.get(field));
                    });
                    sq.start();
                    return sq.getLastEntryExecuted().getObject("outcome");
                }
            };
        }

        @Override
        public String getName() {
            return "denizen";
        }
    }
}

